/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecr.model.AuthorizationData;
import java.util.Date;

@SdkInternalApi
public class AuthorizationDataMarshaller {
    private static final MarshallingInfo<String> AUTHORIZATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationToken").build();
    private static final MarshallingInfo<Date> EXPIRESAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expiresAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> PROXYENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("proxyEndpoint").build();
    private static final AuthorizationDataMarshaller instance = new AuthorizationDataMarshaller();

    public static AuthorizationDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(AuthorizationData authorizationData, ProtocolMarshaller protocolMarshaller) {
        if (authorizationData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)authorizationData.getAuthorizationToken(), AUTHORIZATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)authorizationData.getExpiresAt(), EXPIRESAT_BINDING);
            protocolMarshaller.marshall((Object)authorizationData.getProxyEndpoint(), PROXYENDPOINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

