/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.model.DescribeImageScanFindingsRequest;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import com.amazonaws.services.ecr.waiters.DescribeImageScanFindingsFunction;
import com.amazonaws.services.ecr.waiters.GetLifecyclePolicyPreviewFunction;
import com.amazonaws.services.ecr.waiters.ImageScanComplete;
import com.amazonaws.services.ecr.waiters.LifecyclePolicyPreviewComplete;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonECRWaiters {
    private final AmazonECR client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonECRWaiters");

    @SdkInternalApi
    public AmazonECRWaiters(AmazonECR client) {
        this.client = client;
    }

    public Waiter<DescribeImageScanFindingsRequest> imageScanComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImageScanFindingsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageScanComplete.IsCOMPLETEMatcher(), new ImageScanComplete.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetLifecyclePolicyPreviewRequest> lifecyclePolicyPreviewComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetLifecyclePolicyPreviewFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LifecyclePolicyPreviewComplete.IsCOMPLETEMatcher(), new LifecyclePolicyPreviewComplete.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

