/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ecr.model.Image;
import com.amazonaws.services.ecr.model.ImageFailure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetImageResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Image> images;
    private List<ImageFailure> failures;

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(Collection<Image> images) {
        if (images == null) {
            this.images = null;
            return;
        }
        this.images = new ArrayList<Image>(images);
    }

    public BatchGetImageResult withImages(Image ... images) {
        if (this.images == null) {
            this.setImages(new ArrayList<Image>(images.length));
        }
        for (Image ele : images) {
            this.images.add(ele);
        }
        return this;
    }

    public BatchGetImageResult withImages(Collection<Image> images) {
        this.setImages(images);
        return this;
    }

    public List<ImageFailure> getFailures() {
        return this.failures;
    }

    public void setFailures(Collection<ImageFailure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        this.failures = new ArrayList<ImageFailure>(failures);
    }

    public BatchGetImageResult withFailures(ImageFailure ... failures) {
        if (this.failures == null) {
            this.setFailures(new ArrayList<ImageFailure>(failures.length));
        }
        for (ImageFailure ele : failures) {
            this.failures.add(ele);
        }
        return this;
    }

    public BatchGetImageResult withFailures(Collection<ImageFailure> failures) {
        this.setFailures(failures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImages() != null) {
            sb.append("Images: ").append(this.getImages()).append(",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: ").append(this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageResult)) {
            return false;
        }
        BatchGetImageResult other = (BatchGetImageResult)obj;
        if (other.getImages() == null ^ this.getImages() == null) {
            return false;
        }
        if (other.getImages() != null && !other.getImages().equals(this.getImages())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImages() == null ? 0 : this.getImages().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public BatchGetImageResult clone() {
        try {
            return (BatchGetImageResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

