/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.ImageFailure;
import com.amazonaws.services.ecr.model.transform.ImageIdentifierJsonMarshaller;

public class ImageFailureJsonMarshaller {
    private static ImageFailureJsonMarshaller instance;

    public void marshall(ImageFailure imageFailure, StructuredJsonGenerator jsonGenerator) {
        if (imageFailure == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (imageFailure.getImageId() != null) {
                jsonGenerator.writeFieldName("imageId");
                ImageIdentifierJsonMarshaller.getInstance().marshall(imageFailure.getImageId(), jsonGenerator);
            }
            if (imageFailure.getFailureCode() != null) {
                jsonGenerator.writeFieldName("failureCode").writeValue(imageFailure.getFailureCode());
            }
            if (imageFailure.getFailureReason() != null) {
                jsonGenerator.writeFieldName("failureReason").writeValue(imageFailure.getFailureReason());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageFailureJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageFailureJsonMarshaller();
        }
        return instance;
    }
}

