/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.BatchGetImageRequest;
import com.amazonaws.services.ecr.model.ImageIdentifier;
import com.amazonaws.services.ecr.model.transform.ImageIdentifierJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class BatchGetImageRequestMarshaller
implements Marshaller<Request<BatchGetImageRequest>, BatchGetImageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BatchGetImageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<BatchGetImageRequest> marshall(BatchGetImageRequest batchGetImageRequest) {
        if (batchGetImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchGetImageRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.BatchGetImage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<ImageIdentifier> imageIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (batchGetImageRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(batchGetImageRequest.getRegistryId());
            }
            if (batchGetImageRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(batchGetImageRequest.getRepositoryName());
            }
            if ((imageIdsList = batchGetImageRequest.getImageIds()) != null) {
                jsonGenerator.writeFieldName("imageIds");
                jsonGenerator.writeStartArray();
                for (ImageIdentifier imageIdsListValue : imageIdsList) {
                    if (imageIdsListValue == null) continue;
                    ImageIdentifierJsonMarshaller.getInstance().marshall(imageIdsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

