/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecr.model.ImageDetail;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ImageDetailMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").build();
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").build();
    private static final MarshallingInfo<List> IMAGETAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTags").build();
    private static final MarshallingInfo<Long> IMAGESIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageSizeInBytes").build();
    private static final MarshallingInfo<Date> IMAGEPUSHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePushedAt").timestampFormat("unixTimestamp").build();
    private static final ImageDetailMarshaller instance = new ImageDetailMarshaller();

    public static ImageDetailMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageDetail imageDetail, ProtocolMarshaller protocolMarshaller) {
        if (imageDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageDetail.getRegistryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.getRepositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.getImageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall(imageDetail.getImageTags(), IMAGETAGS_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.getImageSizeInBytes(), IMAGESIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.getImagePushedAt(), IMAGEPUSHEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

