/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteRepositoryPolicyRequestMarshaller
implements Marshaller<Request<DeleteRepositoryPolicyRequest>, DeleteRepositoryPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteRepositoryPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteRepositoryPolicyRequest> marshall(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        if (deleteRepositoryPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteRepositoryPolicyRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.DeleteRepositoryPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteRepositoryPolicyRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(deleteRepositoryPolicyRequest.getRegistryId());
            }
            if (deleteRepositoryPolicyRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(deleteRepositoryPolicyRequest.getRepositoryName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

