/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeRepositoriesRequestMarshaller
implements Marshaller<Request<DescribeRepositoriesRequest>, DescribeRepositoriesRequest> {
    public Request<DescribeRepositoriesRequest> marshall(DescribeRepositoriesRequest describeRepositoriesRequest) {
        if (describeRepositoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRepositoriesRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.DescribeRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> repositoryNamesList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (describeRepositoriesRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(describeRepositoriesRequest.getRegistryId());
            }
            if ((repositoryNamesList = describeRepositoriesRequest.getRepositoryNames()) != null) {
                jsonGenerator.writeFieldName("repositoryNames");
                jsonGenerator.writeStartArray();
                for (String repositoryNamesListValue : repositoryNamesList) {
                    if (repositoryNamesListValue == null) continue;
                    jsonGenerator.writeValue(repositoryNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeRepositoriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeRepositoriesRequest.getNextToken());
            }
            if (describeRepositoriesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue((long)describeRepositoriesRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

