/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AttachClassicLinkVpcRequestMarshaller
implements Marshaller<Request<AttachClassicLinkVpcRequest>, AttachClassicLinkVpcRequest> {
    public Request<AttachClassicLinkVpcRequest> marshall(AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) {
        if (attachClassicLinkVpcRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachClassicLinkVpcRequest, "AmazonEC2");
        request.addParameter("Action", "AttachClassicLinkVpc");
        request.addParameter("Version", "2015-04-15");
        if (attachClassicLinkVpcRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachClassicLinkVpcRequest.getInstanceId()));
        }
        if (attachClassicLinkVpcRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)attachClassicLinkVpcRequest.getVpcId()));
        }
        List<String> groupsList = attachClassicLinkVpcRequest.getGroups();
        int groupsListIndex = 1;
        for (String groupsListValue : groupsList) {
            if (groupsListValue != null) {
                request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
            }
            ++groupsListIndex;
        }
        return request;
    }
}

