/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImportSnapshotRequest;
import com.amazonaws.services.ec2.model.SnapshotDiskContainer;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class ImportSnapshotRequestMarshaller
implements Marshaller<Request<ImportSnapshotRequest>, ImportSnapshotRequest> {
    public Request<ImportSnapshotRequest> marshall(ImportSnapshotRequest importSnapshotRequest) {
        ClientData clientDataClientData;
        SnapshotDiskContainer snapshotDiskContainerDiskContainer;
        if (importSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importSnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "ImportSnapshot");
        request.addParameter("Version", "2015-03-01");
        if (importSnapshotRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importSnapshotRequest.getDescription()));
        }
        if ((snapshotDiskContainerDiskContainer = importSnapshotRequest.getDiskContainer()) != null) {
            UserBucket userBucketUserBucket;
            if (snapshotDiskContainerDiskContainer.getDescription() != null) {
                request.addParameter("DiskContainer.Description", StringUtils.fromString((String)snapshotDiskContainerDiskContainer.getDescription()));
            }
            if (snapshotDiskContainerDiskContainer.getFormat() != null) {
                request.addParameter("DiskContainer.Format", StringUtils.fromString((String)snapshotDiskContainerDiskContainer.getFormat()));
            }
            if (snapshotDiskContainerDiskContainer.getUrl() != null) {
                request.addParameter("DiskContainer.Url", StringUtils.fromString((String)snapshotDiskContainerDiskContainer.getUrl()));
            }
            if ((userBucketUserBucket = snapshotDiskContainerDiskContainer.getUserBucket()) != null) {
                if (userBucketUserBucket.getS3Bucket() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Bucket", StringUtils.fromString((String)userBucketUserBucket.getS3Bucket()));
                }
                if (userBucketUserBucket.getS3Key() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Key", StringUtils.fromString((String)userBucketUserBucket.getS3Key()));
                }
            }
        }
        if ((clientDataClientData = importSnapshotRequest.getClientData()) != null) {
            if (clientDataClientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate((Date)clientDataClientData.getUploadStart()));
            }
            if (clientDataClientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate((Date)clientDataClientData.getUploadEnd()));
            }
            if (clientDataClientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble((Double)clientDataClientData.getUploadSize()));
            }
            if (clientDataClientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString((String)clientDataClientData.getComment()));
            }
        }
        if (importSnapshotRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)importSnapshotRequest.getClientToken()));
        }
        if (importSnapshotRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)importSnapshotRequest.getRoleName()));
        }
        return request;
    }
}

