/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceleratorCount;
import com.amazonaws.services.ec2.model.AcceleratorTotalMemoryMiB;
import com.amazonaws.services.ec2.model.BaselineEbsBandwidthMbps;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.ClassicLoadBalancer;
import com.amazonaws.services.ec2.model.ClassicLoadBalancersConfig;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstanceRequirements;
import com.amazonaws.services.ec2.model.Ipv4PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.Ipv6PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateConfig;
import com.amazonaws.services.ec2.model.LaunchTemplateOverrides;
import com.amazonaws.services.ec2.model.LoadBalancersConfig;
import com.amazonaws.services.ec2.model.MemoryGiBPerVCpu;
import com.amazonaws.services.ec2.model.MemoryMiB;
import com.amazonaws.services.ec2.model.NetworkInterfaceCount;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import com.amazonaws.services.ec2.model.SpotCapacityRebalance;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotFleetMonitoring;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfigData;
import com.amazonaws.services.ec2.model.SpotFleetTagSpecification;
import com.amazonaws.services.ec2.model.SpotMaintenanceStrategies;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TargetGroup;
import com.amazonaws.services.ec2.model.TargetGroupsConfig;
import com.amazonaws.services.ec2.model.TotalLocalStorageGB;
import com.amazonaws.services.ec2.model.VCpuCountRange;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Iterator;

public class RequestSpotFleetRequestMarshaller
implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {
    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {
        if (requestSpotFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotFleetRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SpotFleetRequestConfigData spotFleetRequestConfig = requestSpotFleetRequest.getSpotFleetRequestConfig();
        if (spotFleetRequestConfig != null) {
            SdkInternalList spotFleetRequestConfigDataTagSpecificationsList;
            LoadBalancersConfig loadBalancersConfig;
            SdkInternalList spotFleetRequestConfigDataLaunchTemplateConfigsList;
            Iterator spotFleetLaunchSpecificationNetworkInterfacesList;
            SdkInternalList spotFleetRequestConfigDataLaunchSpecificationsList;
            SpotCapacityRebalance capacityRebalance;
            SpotMaintenanceStrategies spotMaintenanceStrategies;
            if (spotFleetRequestConfig.getAllocationStrategy() != null) {
                request.addParameter("SpotFleetRequestConfig.AllocationStrategy", StringUtils.fromString((String)spotFleetRequestConfig.getAllocationStrategy()));
            }
            if (spotFleetRequestConfig.getOnDemandAllocationStrategy() != null) {
                request.addParameter("SpotFleetRequestConfig.OnDemandAllocationStrategy", StringUtils.fromString((String)spotFleetRequestConfig.getOnDemandAllocationStrategy()));
            }
            if ((spotMaintenanceStrategies = spotFleetRequestConfig.getSpotMaintenanceStrategies()) != null && (capacityRebalance = spotMaintenanceStrategies.getCapacityRebalance()) != null && capacityRebalance.getReplacementStrategy() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotMaintenanceStrategies.CapacityRebalance.ReplacementStrategy", StringUtils.fromString((String)capacityRebalance.getReplacementStrategy()));
            }
            if (spotFleetRequestConfig.getClientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken", StringUtils.fromString((String)spotFleetRequestConfig.getClientToken()));
            }
            if (spotFleetRequestConfig.getExcessCapacityTerminationPolicy() != null) {
                request.addParameter("SpotFleetRequestConfig.ExcessCapacityTerminationPolicy", StringUtils.fromString((String)spotFleetRequestConfig.getExcessCapacityTerminationPolicy()));
            }
            if (spotFleetRequestConfig.getFulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.FulfilledCapacity", StringUtils.fromDouble((Double)spotFleetRequestConfig.getFulfilledCapacity()));
            }
            if (spotFleetRequestConfig.getOnDemandFulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.OnDemandFulfilledCapacity", StringUtils.fromDouble((Double)spotFleetRequestConfig.getOnDemandFulfilledCapacity()));
            }
            if (spotFleetRequestConfig.getIamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole", StringUtils.fromString((String)spotFleetRequestConfig.getIamFleetRole()));
            }
            if (!(spotFleetRequestConfigDataLaunchSpecificationsList = (SdkInternalList)spotFleetRequestConfig.getLaunchSpecifications()).isEmpty() || !spotFleetRequestConfigDataLaunchSpecificationsList.isAutoConstruct()) {
                int launchSpecificationsListIndex = 1;
                for (Object spotFleetRequestConfigDataLaunchSpecificationsListValue : spotFleetRequestConfigDataLaunchSpecificationsList) {
                    InstanceRequirements instanceRequirements;
                    SdkInternalList spotFleetLaunchSpecificationTagSpecificationsList;
                    SpotPlacement placement;
                    Iterator instanceNetworkInterfaceSpecificationIpv6PrefixesList;
                    Object instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2;
                    Object instanceNetworkInterfaceSpecificationGroupsList;
                    SpotFleetMonitoring monitoring;
                    IamInstanceProfileSpecification iamInstanceProfile;
                    SdkInternalList spotFleetLaunchSpecificationBlockDeviceMappingsList;
                    SdkInternalList spotFleetLaunchSpecificationSecurityGroupsList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSecurityGroups();
                    if (!spotFleetLaunchSpecificationSecurityGroupsList.isEmpty() || !spotFleetLaunchSpecificationSecurityGroupsList.isAutoConstruct()) {
                        int securityGroupsListIndex = 1;
                        for (Object spotFleetLaunchSpecificationSecurityGroupsListValue : spotFleetLaunchSpecificationSecurityGroupsList) {
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName", StringUtils.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupName()));
                            }
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId", StringUtils.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupId()));
                            }
                            ++securityGroupsListIndex;
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getAddressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".AddressingType", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getAddressingType()));
                    }
                    if (!(spotFleetLaunchSpecificationBlockDeviceMappingsList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getBlockDeviceMappings()).isEmpty() || !spotFleetLaunchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                        Object spotFleetLaunchSpecificationSecurityGroupsListValue;
                        int blockDeviceMappingsListIndex = 1;
                        spotFleetLaunchSpecificationSecurityGroupsListValue = spotFleetLaunchSpecificationBlockDeviceMappingsList.iterator();
                        while (spotFleetLaunchSpecificationSecurityGroupsListValue.hasNext()) {
                            EbsBlockDevice ebs;
                            BlockDeviceMapping spotFleetLaunchSpecificationBlockDeviceMappingsListValue = (BlockDeviceMapping)spotFleetLaunchSpecificationSecurityGroupsListValue.next();
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName()));
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName()));
                            }
                            if ((ebs = spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getEbs()) != null) {
                                if (ebs.getDeleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                                }
                                if (ebs.getIops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                                }
                                if (ebs.getSnapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                                }
                                if (ebs.getVolumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                                }
                                if (ebs.getVolumeType() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                                }
                                if (ebs.getKmsKeyId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString((String)ebs.getKmsKeyId()));
                                }
                                if (ebs.getThroughput() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger((Integer)ebs.getThroughput()));
                                }
                                if (ebs.getOutpostArn() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.OutpostArn", StringUtils.fromString((String)ebs.getOutpostArn()));
                                }
                                if (ebs.getEncrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                                }
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice()));
                            }
                            ++blockDeviceMappingsListIndex;
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getEbsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".EbsOptimized", StringUtils.fromBoolean((Boolean)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getEbsOptimized()));
                    }
                    if ((iamInstanceProfile = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getIamInstanceProfile()) != null) {
                        if (iamInstanceProfile.getArn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
                        }
                        if (iamInstanceProfile.getName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getImageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".ImageId", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getImageId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getInstanceType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceType", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getInstanceType()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KernelId", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKernelId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKeyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KeyName", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKeyName()));
                    }
                    if ((monitoring = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getMonitoring()) != null && monitoring.getEnabled() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Monitoring.Enabled", StringUtils.fromBoolean((Boolean)monitoring.getEnabled()));
                    }
                    if (!(spotFleetLaunchSpecificationNetworkInterfacesList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getNetworkInterfaces()).isEmpty() || !spotFleetLaunchSpecificationNetworkInterfacesList.isAutoConstruct()) {
                        int networkInterfacesListIndex = 1;
                        Iterator iterator = spotFleetLaunchSpecificationNetworkInterfacesList.iterator();
                        while (iterator.hasNext()) {
                            SdkInternalList instanceNetworkInterfaceSpecificationIpv4PrefixesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                            InstanceNetworkInterfaceSpecification spotFleetLaunchSpecificationNetworkInterfacesListValue = (InstanceNetworkInterfaceSpecification)iterator.next();
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDescription() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getDescription()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                                int groupsListIndex = 1;
                                Iterator iterator2 = instanceNetworkInterfaceSpecificationGroupsList.iterator();
                                while (iterator2.hasNext()) {
                                    String instanceNetworkInterfaceSpecificationGroupsListValue = (String)iterator2.next();
                                    if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                                    }
                                    ++groupsListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                                int ipv6AddressesListIndex = 1;
                                for (Object instanceNetworkInterfaceSpecificationIpv6AddressesListValue : instanceNetworkInterfaceSpecificationIpv6AddressesList) {
                                    if (((InstanceIpv6Address)instanceNetworkInterfaceSpecificationIpv6AddressesListValue).getIpv6Address() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)((InstanceIpv6Address)instanceNetworkInterfaceSpecificationIpv6AddressesListValue).getIpv6Address()));
                                    }
                                    ++ipv6AddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                                Object instanceNetworkInterfaceSpecificationIpv6AddressesListValue;
                                int privateIpAddressesListIndex = 1;
                                instanceNetworkInterfaceSpecificationIpv6AddressesListValue = instanceNetworkInterfaceSpecificationPrivateIpAddressesList.iterator();
                                while (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.hasNext()) {
                                    PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue = (PrivateIpAddressSpecification)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.next();
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary()));
                                    }
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress()));
                                    }
                                    ++privateIpAddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getSubnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getSubnetId()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociateCarrierIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociateCarrierIpAddress", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociateCarrierIpAddress()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getInterfaceType() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".InterfaceType", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.getInterfaceType()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkCardIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkCardIndex", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkCardIndex()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationIpv4PrefixesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv4Prefixes()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv4PrefixesList.isAutoConstruct()) {
                                int ipv4PrefixesListIndex = 1;
                                for (Object instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2 : instanceNetworkInterfaceSpecificationIpv4PrefixesList) {
                                    if (((Ipv4PrefixSpecificationRequest)instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2).getIpv4Prefix() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv4Prefix." + ipv4PrefixesListIndex + ".Ipv4Prefix", StringUtils.fromString((String)((Ipv4PrefixSpecificationRequest)instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2).getIpv4Prefix()));
                                    }
                                    ++ipv4PrefixesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv4PrefixCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv4PrefixCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv4PrefixCount()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationIpv6PrefixesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6Prefixes()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6PrefixesList.isAutoConstruct()) {
                                int ipv6PrefixesListIndex = 1;
                                instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2 = instanceNetworkInterfaceSpecificationIpv6PrefixesList.iterator();
                                while (instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2.hasNext()) {
                                    Ipv6PrefixSpecificationRequest instanceNetworkInterfaceSpecificationIpv6PrefixesListValue = (Ipv6PrefixSpecificationRequest)instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2.next();
                                    if (instanceNetworkInterfaceSpecificationIpv6PrefixesListValue.getIpv6Prefix() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6Prefix." + ipv6PrefixesListIndex + ".Ipv6Prefix", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv6PrefixesListValue.getIpv6Prefix()));
                                    }
                                    ++ipv6PrefixesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6PrefixCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6PrefixCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6PrefixCount()));
                            }
                            ++networkInterfacesListIndex;
                        }
                    }
                    if ((placement = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getPlacement()) != null) {
                        if (placement.getAvailabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                        }
                        if (placement.getGroupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                        }
                        if (placement.getTenancy() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getRamdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".RamdiskId", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getRamdiskId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSpotPrice() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SpotPrice", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSpotPrice()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSubnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SubnetId", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSubnetId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getUserData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".UserData", StringUtils.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getUserData()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getWeightedCapacity() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getWeightedCapacity()));
                    }
                    if (!(spotFleetLaunchSpecificationTagSpecificationsList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getTagSpecifications()).isEmpty() || !spotFleetLaunchSpecificationTagSpecificationsList.isAutoConstruct()) {
                        int tagSpecificationsListIndex = 1;
                        instanceNetworkInterfaceSpecificationGroupsList = spotFleetLaunchSpecificationTagSpecificationsList.iterator();
                        while (instanceNetworkInterfaceSpecificationGroupsList.hasNext()) {
                            SdkInternalList spotFleetTagSpecificationTagsList;
                            SpotFleetTagSpecification spotFleetLaunchSpecificationTagSpecificationsListValue = (SpotFleetTagSpecification)instanceNetworkInterfaceSpecificationGroupsList.next();
                            if (spotFleetLaunchSpecificationTagSpecificationsListValue.getResourceType() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)spotFleetLaunchSpecificationTagSpecificationsListValue.getResourceType()));
                            }
                            if (!(spotFleetTagSpecificationTagsList = (SdkInternalList)spotFleetLaunchSpecificationTagSpecificationsListValue.getTags()).isEmpty() || !spotFleetTagSpecificationTagsList.isAutoConstruct()) {
                                int tagsListIndex = 1;
                                instanceNetworkInterfaceSpecificationIpv6PrefixesList = spotFleetTagSpecificationTagsList.iterator();
                                while (instanceNetworkInterfaceSpecificationIpv6PrefixesList.hasNext()) {
                                    Tag spotFleetTagSpecificationTagsListValue = (Tag)instanceNetworkInterfaceSpecificationIpv6PrefixesList.next();
                                    if (spotFleetTagSpecificationTagsListValue.getKey() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)spotFleetTagSpecificationTagsListValue.getKey()));
                                    }
                                    if (spotFleetTagSpecificationTagsListValue.getValue() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)spotFleetTagSpecificationTagsListValue.getValue()));
                                    }
                                    ++tagsListIndex;
                                }
                            }
                            ++tagSpecificationsListIndex;
                        }
                    }
                    if ((instanceRequirements = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getInstanceRequirements()) != null) {
                        AcceleratorTotalMemoryMiB acceleratorTotalMemoryMiB;
                        Iterator instanceRequirementsAcceleratorNamesList;
                        SdkInternalList instanceRequirementsAcceleratorManufacturersList;
                        Object acceleratorCount;
                        SdkInternalList instanceRequirementsAcceleratorTypesList;
                        BaselineEbsBandwidthMbps baselineEbsBandwidthMbps;
                        Object totalLocalStorageGB;
                        SdkInternalList instanceRequirementsLocalStorageTypesList;
                        NetworkInterfaceCount networkInterfaceCount;
                        SdkInternalList instanceRequirementsInstanceGenerationsList;
                        SdkInternalList instanceRequirementsExcludedInstanceTypesList;
                        MemoryGiBPerVCpu memoryGiBPerVCpu;
                        SdkInternalList instanceRequirementsCpuManufacturersList;
                        MemoryMiB memoryMiB;
                        VCpuCountRange vCpuCount = instanceRequirements.getVCpuCount();
                        if (vCpuCount != null) {
                            if (vCpuCount.getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                            }
                            if (vCpuCount.getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                            }
                        }
                        if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                            if (memoryMiB.getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                            }
                            if (memoryMiB.getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                            }
                        }
                        if (!(instanceRequirementsCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsCpuManufacturersList.isAutoConstruct()) {
                            int cpuManufacturersListIndex = 1;
                            instanceNetworkInterfaceSpecificationIpv6PrefixesList = instanceRequirementsCpuManufacturersList.iterator();
                            while (instanceNetworkInterfaceSpecificationIpv6PrefixesList.hasNext()) {
                                String instanceRequirementsCpuManufacturersListValue = (String)instanceNetworkInterfaceSpecificationIpv6PrefixesList.next();
                                if (instanceRequirementsCpuManufacturersListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.CpuManufacturerSet." + cpuManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsCpuManufacturersListValue));
                                }
                                ++cpuManufacturersListIndex;
                            }
                        }
                        if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                            if (memoryGiBPerVCpu.getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                            }
                            if (memoryGiBPerVCpu.getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                            }
                        }
                        if (!(instanceRequirementsExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsExcludedInstanceTypesList.isAutoConstruct()) {
                            int excludedInstanceTypesListIndex = 1;
                            instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2 = instanceRequirementsExcludedInstanceTypesList.iterator();
                            while (instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2.hasNext()) {
                                String instanceRequirementsExcludedInstanceTypesListValue = (String)instanceNetworkInterfaceSpecificationIpv4PrefixesListValue2.next();
                                if (instanceRequirementsExcludedInstanceTypesListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.ExcludedInstanceTypeSet." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsExcludedInstanceTypesListValue));
                                }
                                ++excludedInstanceTypesListIndex;
                            }
                        }
                        if (!(instanceRequirementsInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsInstanceGenerationsList.isAutoConstruct()) {
                            int instanceGenerationsListIndex = 1;
                            for (String instanceRequirementsInstanceGenerationsListValue : instanceRequirementsInstanceGenerationsList) {
                                if (instanceRequirementsInstanceGenerationsListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.InstanceGenerationSet." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceRequirementsInstanceGenerationsListValue));
                                }
                                ++instanceGenerationsListIndex;
                            }
                        }
                        if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                        }
                        if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                        }
                        if (instanceRequirements.getBareMetal() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                        }
                        if (instanceRequirements.getBurstablePerformance() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                        }
                        if (instanceRequirements.getRequireHibernateSupport() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                        }
                        if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                            if (networkInterfaceCount.getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                            }
                            if (networkInterfaceCount.getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                            }
                        }
                        if (instanceRequirements.getLocalStorage() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                        }
                        if (!(instanceRequirementsLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsLocalStorageTypesList.isAutoConstruct()) {
                            int localStorageTypesListIndex = 1;
                            for (String instanceRequirementsLocalStorageTypesListValue : instanceRequirementsLocalStorageTypesList) {
                                if (instanceRequirementsLocalStorageTypesListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.LocalStorageTypeSet." + localStorageTypesListIndex, StringUtils.fromString((String)instanceRequirementsLocalStorageTypesListValue));
                                }
                                ++localStorageTypesListIndex;
                            }
                        }
                        if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                            if (((TotalLocalStorageGB)totalLocalStorageGB).getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)((TotalLocalStorageGB)totalLocalStorageGB).getMin()));
                            }
                            if (((TotalLocalStorageGB)totalLocalStorageGB).getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)((TotalLocalStorageGB)totalLocalStorageGB).getMax()));
                            }
                        }
                        if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                            if (baselineEbsBandwidthMbps.getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                            }
                            if (baselineEbsBandwidthMbps.getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                            }
                        }
                        if (!(instanceRequirementsAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsAcceleratorTypesList.isAutoConstruct()) {
                            int acceleratorTypesListIndex = 1;
                            for (String instanceRequirementsAcceleratorTypesListValue : instanceRequirementsAcceleratorTypesList) {
                                if (instanceRequirementsAcceleratorTypesListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.AcceleratorTypeSet." + acceleratorTypesListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorTypesListValue));
                                }
                                ++acceleratorTypesListIndex;
                            }
                        }
                        if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                            if (((AcceleratorCount)acceleratorCount).getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)((AcceleratorCount)acceleratorCount).getMin()));
                            }
                            if (((AcceleratorCount)acceleratorCount).getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)((AcceleratorCount)acceleratorCount).getMax()));
                            }
                        }
                        if (!(instanceRequirementsAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsAcceleratorManufacturersList.isAutoConstruct()) {
                            int acceleratorManufacturersListIndex = 1;
                            for (Object instanceRequirementsAcceleratorManufacturersListValue : instanceRequirementsAcceleratorManufacturersList) {
                                if (instanceRequirementsAcceleratorManufacturersListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.AcceleratorManufacturerSet." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorManufacturersListValue));
                                }
                                ++acceleratorManufacturersListIndex;
                            }
                        }
                        if (!(instanceRequirementsAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsAcceleratorNamesList.isAutoConstruct()) {
                            Object instanceRequirementsAcceleratorManufacturersListValue;
                            int acceleratorNamesListIndex = 1;
                            instanceRequirementsAcceleratorManufacturersListValue = instanceRequirementsAcceleratorNamesList.iterator();
                            while (instanceRequirementsAcceleratorManufacturersListValue.hasNext()) {
                                String instanceRequirementsAcceleratorNamesListValue = (String)instanceRequirementsAcceleratorManufacturersListValue.next();
                                if (instanceRequirementsAcceleratorNamesListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.AcceleratorNameSet." + acceleratorNamesListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorNamesListValue));
                                }
                                ++acceleratorNamesListIndex;
                            }
                        }
                        if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                            if (acceleratorTotalMemoryMiB.getMin() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                            }
                            if (acceleratorTotalMemoryMiB.getMax() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                            }
                        }
                    }
                    ++launchSpecificationsListIndex;
                }
            }
            if (!(spotFleetRequestConfigDataLaunchTemplateConfigsList = (SdkInternalList)spotFleetRequestConfig.getLaunchTemplateConfigs()).isEmpty() || !spotFleetRequestConfigDataLaunchTemplateConfigsList.isAutoConstruct()) {
                int launchTemplateConfigsListIndex = 1;
                for (LaunchTemplateConfig spotFleetRequestConfigDataLaunchTemplateConfigsListValue : spotFleetRequestConfigDataLaunchTemplateConfigsList) {
                    Object launchTemplateConfigOverridesList;
                    FleetLaunchTemplateSpecification launchTemplateSpecification = spotFleetRequestConfigDataLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                    if (launchTemplateSpecification != null) {
                        if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                        }
                        if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                        }
                        if (launchTemplateSpecification.getVersion() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                        }
                    }
                    if (!(launchTemplateConfigOverridesList = (SdkInternalList)spotFleetRequestConfigDataLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !launchTemplateConfigOverridesList.isAutoConstruct()) {
                        int overridesListIndex = 1;
                        spotFleetLaunchSpecificationNetworkInterfacesList = launchTemplateConfigOverridesList.iterator();
                        while (spotFleetLaunchSpecificationNetworkInterfacesList.hasNext()) {
                            InstanceRequirements instanceRequirements;
                            LaunchTemplateOverrides launchTemplateConfigOverridesListValue = (LaunchTemplateOverrides)spotFleetLaunchSpecificationNetworkInterfacesList.next();
                            if (launchTemplateConfigOverridesListValue.getInstanceType() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getInstanceType()));
                            }
                            if (launchTemplateConfigOverridesListValue.getSpotPrice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SpotPrice", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getSpotPrice()));
                            }
                            if (launchTemplateConfigOverridesListValue.getSubnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getSubnetId()));
                            }
                            if (launchTemplateConfigOverridesListValue.getAvailabilityZone() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getAvailabilityZone()));
                            }
                            if (launchTemplateConfigOverridesListValue.getWeightedCapacity() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)launchTemplateConfigOverridesListValue.getWeightedCapacity()));
                            }
                            if (launchTemplateConfigOverridesListValue.getPriority() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble((Double)launchTemplateConfigOverridesListValue.getPriority()));
                            }
                            if ((instanceRequirements = launchTemplateConfigOverridesListValue.getInstanceRequirements()) != null) {
                                AcceleratorTotalMemoryMiB acceleratorTotalMemoryMiB;
                                SdkInternalList instanceRequirementsAcceleratorNamesList;
                                SdkInternalList instanceRequirementsAcceleratorManufacturersList;
                                AcceleratorCount acceleratorCount;
                                SdkInternalList instanceRequirementsAcceleratorTypesList;
                                BaselineEbsBandwidthMbps baselineEbsBandwidthMbps;
                                TotalLocalStorageGB totalLocalStorageGB;
                                SdkInternalList instanceRequirementsLocalStorageTypesList;
                                NetworkInterfaceCount networkInterfaceCount;
                                SdkInternalList instanceRequirementsInstanceGenerationsList;
                                SdkInternalList instanceRequirementsExcludedInstanceTypesList;
                                MemoryGiBPerVCpu memoryGiBPerVCpu;
                                SdkInternalList instanceRequirementsCpuManufacturersList;
                                MemoryMiB memoryMiB;
                                VCpuCountRange vCpuCount = instanceRequirements.getVCpuCount();
                                if (vCpuCount != null) {
                                    if (vCpuCount.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                                    }
                                    if (vCpuCount.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                                    }
                                }
                                if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                                    if (memoryMiB.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                                    }
                                    if (memoryMiB.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                                    }
                                }
                                if (!(instanceRequirementsCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsCpuManufacturersList.isAutoConstruct()) {
                                    int cpuManufacturersListIndex = 1;
                                    for (String instanceRequirementsCpuManufacturersListValue : instanceRequirementsCpuManufacturersList) {
                                        if (instanceRequirementsCpuManufacturersListValue != null) {
                                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.CpuManufacturerSet." + cpuManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsCpuManufacturersListValue));
                                        }
                                        ++cpuManufacturersListIndex;
                                    }
                                }
                                if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                                    if (memoryGiBPerVCpu.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                                    }
                                    if (memoryGiBPerVCpu.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                                    }
                                }
                                if (!(instanceRequirementsExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsExcludedInstanceTypesList.isAutoConstruct()) {
                                    int excludedInstanceTypesListIndex = 1;
                                    for (Object instanceRequirementsExcludedInstanceTypesListValue : instanceRequirementsExcludedInstanceTypesList) {
                                        if (instanceRequirementsExcludedInstanceTypesListValue != null) {
                                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.ExcludedInstanceTypeSet." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsExcludedInstanceTypesListValue));
                                        }
                                        ++excludedInstanceTypesListIndex;
                                    }
                                }
                                if (!(instanceRequirementsInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsInstanceGenerationsList.isAutoConstruct()) {
                                    Object instanceRequirementsExcludedInstanceTypesListValue;
                                    int instanceGenerationsListIndex = 1;
                                    instanceRequirementsExcludedInstanceTypesListValue = instanceRequirementsInstanceGenerationsList.iterator();
                                    while (instanceRequirementsExcludedInstanceTypesListValue.hasNext()) {
                                        String instanceRequirementsInstanceGenerationsListValue = (String)instanceRequirementsExcludedInstanceTypesListValue.next();
                                        if (instanceRequirementsInstanceGenerationsListValue != null) {
                                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.InstanceGenerationSet." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceRequirementsInstanceGenerationsListValue));
                                        }
                                        ++instanceGenerationsListIndex;
                                    }
                                }
                                if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                                }
                                if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                                }
                                if (instanceRequirements.getBareMetal() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                                }
                                if (instanceRequirements.getBurstablePerformance() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                                }
                                if (instanceRequirements.getRequireHibernateSupport() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                                }
                                if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                                    if (networkInterfaceCount.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                                    }
                                    if (networkInterfaceCount.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                                    }
                                }
                                if (instanceRequirements.getLocalStorage() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                                }
                                if (!(instanceRequirementsLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsLocalStorageTypesList.isAutoConstruct()) {
                                    int localStorageTypesListIndex = 1;
                                    for (String instanceRequirementsLocalStorageTypesListValue : instanceRequirementsLocalStorageTypesList) {
                                        if (instanceRequirementsLocalStorageTypesListValue != null) {
                                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorageTypeSet." + localStorageTypesListIndex, StringUtils.fromString((String)instanceRequirementsLocalStorageTypesListValue));
                                        }
                                        ++localStorageTypesListIndex;
                                    }
                                }
                                if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                                    if (totalLocalStorageGB.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)totalLocalStorageGB.getMin()));
                                    }
                                    if (totalLocalStorageGB.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)totalLocalStorageGB.getMax()));
                                    }
                                }
                                if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                                    if (baselineEbsBandwidthMbps.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                                    }
                                    if (baselineEbsBandwidthMbps.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                                    }
                                }
                                if (!(instanceRequirementsAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsAcceleratorTypesList.isAutoConstruct()) {
                                    int acceleratorTypesListIndex = 1;
                                    for (String instanceRequirementsAcceleratorTypesListValue : instanceRequirementsAcceleratorTypesList) {
                                        if (instanceRequirementsAcceleratorTypesListValue != null) {
                                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTypeSet." + acceleratorTypesListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorTypesListValue));
                                        }
                                        ++acceleratorTypesListIndex;
                                    }
                                }
                                if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                                    if (acceleratorCount.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)acceleratorCount.getMin()));
                                    }
                                    if (acceleratorCount.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)acceleratorCount.getMax()));
                                    }
                                }
                                if (!(instanceRequirementsAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsAcceleratorManufacturersList.isAutoConstruct()) {
                                    int acceleratorManufacturersListIndex = 1;
                                    for (String instanceRequirementsAcceleratorManufacturersListValue : instanceRequirementsAcceleratorManufacturersList) {
                                        if (instanceRequirementsAcceleratorManufacturersListValue != null) {
                                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorManufacturerSet." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorManufacturersListValue));
                                        }
                                        ++acceleratorManufacturersListIndex;
                                    }
                                }
                                if (!(instanceRequirementsAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsAcceleratorNamesList.isAutoConstruct()) {
                                    int acceleratorNamesListIndex = 1;
                                    for (String instanceRequirementsAcceleratorNamesListValue : instanceRequirementsAcceleratorNamesList) {
                                        if (instanceRequirementsAcceleratorNamesListValue != null) {
                                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorNameSet." + acceleratorNamesListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorNamesListValue));
                                        }
                                        ++acceleratorNamesListIndex;
                                    }
                                }
                                if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                                    if (acceleratorTotalMemoryMiB.getMin() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                                    }
                                    if (acceleratorTotalMemoryMiB.getMax() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                                    }
                                }
                            }
                            ++overridesListIndex;
                        }
                    }
                    ++launchTemplateConfigsListIndex;
                }
            }
            if (spotFleetRequestConfig.getSpotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice", StringUtils.fromString((String)spotFleetRequestConfig.getSpotPrice()));
            }
            if (spotFleetRequestConfig.getTargetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity", StringUtils.fromInteger((Integer)spotFleetRequestConfig.getTargetCapacity()));
            }
            if (spotFleetRequestConfig.getOnDemandTargetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.OnDemandTargetCapacity", StringUtils.fromInteger((Integer)spotFleetRequestConfig.getOnDemandTargetCapacity()));
            }
            if (spotFleetRequestConfig.getOnDemandMaxTotalPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.OnDemandMaxTotalPrice", StringUtils.fromString((String)spotFleetRequestConfig.getOnDemandMaxTotalPrice()));
            }
            if (spotFleetRequestConfig.getSpotMaxTotalPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotMaxTotalPrice", StringUtils.fromString((String)spotFleetRequestConfig.getSpotMaxTotalPrice()));
            }
            if (spotFleetRequestConfig.getTerminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration", StringUtils.fromBoolean((Boolean)spotFleetRequestConfig.getTerminateInstancesWithExpiration()));
            }
            if (spotFleetRequestConfig.getType() != null) {
                request.addParameter("SpotFleetRequestConfig.Type", StringUtils.fromString((String)spotFleetRequestConfig.getType()));
            }
            if (spotFleetRequestConfig.getValidFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom", StringUtils.fromDate((Date)spotFleetRequestConfig.getValidFrom()));
            }
            if (spotFleetRequestConfig.getValidUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil", StringUtils.fromDate((Date)spotFleetRequestConfig.getValidUntil()));
            }
            if (spotFleetRequestConfig.getReplaceUnhealthyInstances() != null) {
                request.addParameter("SpotFleetRequestConfig.ReplaceUnhealthyInstances", StringUtils.fromBoolean((Boolean)spotFleetRequestConfig.getReplaceUnhealthyInstances()));
            }
            if (spotFleetRequestConfig.getInstanceInterruptionBehavior() != null) {
                request.addParameter("SpotFleetRequestConfig.InstanceInterruptionBehavior", StringUtils.fromString((String)spotFleetRequestConfig.getInstanceInterruptionBehavior()));
            }
            if ((loadBalancersConfig = spotFleetRequestConfig.getLoadBalancersConfig()) != null) {
                SdkInternalList targetGroupsConfigTargetGroupsList;
                TargetGroupsConfig targetGroupsConfig;
                SdkInternalList classicLoadBalancersConfigClassicLoadBalancersList;
                ClassicLoadBalancersConfig classicLoadBalancersConfig = loadBalancersConfig.getClassicLoadBalancersConfig();
                if (!(classicLoadBalancersConfig == null || (classicLoadBalancersConfigClassicLoadBalancersList = (SdkInternalList)classicLoadBalancersConfig.getClassicLoadBalancers()).isEmpty() && classicLoadBalancersConfigClassicLoadBalancersList.isAutoConstruct())) {
                    int classicLoadBalancersListIndex = 1;
                    for (ClassicLoadBalancer classicLoadBalancersConfigClassicLoadBalancersListValue : classicLoadBalancersConfigClassicLoadBalancersList) {
                        if (classicLoadBalancersConfigClassicLoadBalancersListValue.getName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LoadBalancersConfig.ClassicLoadBalancersConfig.ClassicLoadBalancers." + classicLoadBalancersListIndex + ".Name", StringUtils.fromString((String)classicLoadBalancersConfigClassicLoadBalancersListValue.getName()));
                        }
                        ++classicLoadBalancersListIndex;
                    }
                }
                if (!((targetGroupsConfig = loadBalancersConfig.getTargetGroupsConfig()) == null || (targetGroupsConfigTargetGroupsList = (SdkInternalList)targetGroupsConfig.getTargetGroups()).isEmpty() && targetGroupsConfigTargetGroupsList.isAutoConstruct())) {
                    int targetGroupsListIndex = 1;
                    for (TargetGroup targetGroupsConfigTargetGroupsListValue : targetGroupsConfigTargetGroupsList) {
                        if (targetGroupsConfigTargetGroupsListValue.getArn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LoadBalancersConfig.TargetGroupsConfig.TargetGroups." + targetGroupsListIndex + ".Arn", StringUtils.fromString((String)targetGroupsConfigTargetGroupsListValue.getArn()));
                        }
                        ++targetGroupsListIndex;
                    }
                }
            }
            if (spotFleetRequestConfig.getInstancePoolsToUseCount() != null) {
                request.addParameter("SpotFleetRequestConfig.InstancePoolsToUseCount", StringUtils.fromInteger((Integer)spotFleetRequestConfig.getInstancePoolsToUseCount()));
            }
            if (spotFleetRequestConfig.getContext() != null) {
                request.addParameter("SpotFleetRequestConfig.Context", StringUtils.fromString((String)spotFleetRequestConfig.getContext()));
            }
            if (spotFleetRequestConfig.getTargetCapacityUnitType() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacityUnitType", StringUtils.fromString((String)spotFleetRequestConfig.getTargetCapacityUnitType()));
            }
            if (!(spotFleetRequestConfigDataTagSpecificationsList = (SdkInternalList)spotFleetRequestConfig.getTagSpecifications()).isEmpty() || !spotFleetRequestConfigDataTagSpecificationsList.isAutoConstruct()) {
                int tagSpecificationsListIndex = 1;
                for (TagSpecification spotFleetRequestConfigDataTagSpecificationsListValue : spotFleetRequestConfigDataTagSpecificationsList) {
                    SdkInternalList tagSpecificationTagsList;
                    if (spotFleetRequestConfigDataTagSpecificationsListValue.getResourceType() != null) {
                        request.addParameter("SpotFleetRequestConfig.TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)spotFleetRequestConfigDataTagSpecificationsListValue.getResourceType()));
                    }
                    if (!(tagSpecificationTagsList = (SdkInternalList)spotFleetRequestConfigDataTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                        int tagsListIndex = 1;
                        for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                            if (tagSpecificationTagsListValue.getKey() != null) {
                                request.addParameter("SpotFleetRequestConfig.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                            }
                            if (tagSpecificationTagsListValue.getValue() != null) {
                                request.addParameter("SpotFleetRequestConfig.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                            }
                            ++tagsListIndex;
                        }
                    }
                    ++tagSpecificationsListIndex;
                }
            }
        }
        return request;
    }
}

