/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.IdempotentUtils;

/**
 * ModifyVerifiedAccessEndpointPolicyRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ModifyVerifiedAccessEndpointPolicyRequestMarshaller implements
        Marshaller<Request<ModifyVerifiedAccessEndpointPolicyRequest>, ModifyVerifiedAccessEndpointPolicyRequest> {

    public Request<ModifyVerifiedAccessEndpointPolicyRequest> marshall(ModifyVerifiedAccessEndpointPolicyRequest modifyVerifiedAccessEndpointPolicyRequest) {

        if (modifyVerifiedAccessEndpointPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyVerifiedAccessEndpointPolicyRequest> request = new DefaultRequest<ModifyVerifiedAccessEndpointPolicyRequest>(
                modifyVerifiedAccessEndpointPolicyRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessEndpointPolicy");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyVerifiedAccessEndpointPolicyRequest.getVerifiedAccessEndpointId() != null) {
            request.addParameter("VerifiedAccessEndpointId", StringUtils.fromString(modifyVerifiedAccessEndpointPolicyRequest.getVerifiedAccessEndpointId()));
        }

        if (modifyVerifiedAccessEndpointPolicyRequest.getPolicyEnabled() != null) {
            request.addParameter("PolicyEnabled", StringUtils.fromBoolean(modifyVerifiedAccessEndpointPolicyRequest.getPolicyEnabled()));
        }

        if (modifyVerifiedAccessEndpointPolicyRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(modifyVerifiedAccessEndpointPolicyRequest.getPolicyDocument()));
        }

        request.addParameter("ClientToken", IdempotentUtils.resolveString(modifyVerifiedAccessEndpointPolicyRequest.getClientToken()));

        VerifiedAccessSseSpecificationRequest sseSpecification = modifyVerifiedAccessEndpointPolicyRequest.getSseSpecification();
        if (sseSpecification != null) {

            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean(sseSpecification.getCustomerManagedKeyEnabled()));
            }

            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString(sseSpecification.getKmsKeyArn()));
            }
        }

        return request;
    }

}
