/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Describes a route table propagation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRouteTablePropagation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TransitGatewayRouteTablePropagation implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     */
    private String transitGatewayAttachmentId;
    /**
     * <p>
     * The ID of the resource.
     * </p>
     */
    private String resourceId;
    /**
     * <p>
     * The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     */
    private String resourceType;
    /**
     * <p>
     * The state of the resource.
     * </p>
     */
    private String state;
    /**
     * <p>
     * The ID of the transit gateway route table announcement.
     * </p>
     */
    private String transitGatewayRouteTableAnnouncementId;

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @param transitGatewayAttachmentId
     *        The ID of the attachment.
     */

    public void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
        this.transitGatewayAttachmentId = transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */

    public String getTransitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @param transitGatewayAttachmentId
     *        The ID of the attachment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransitGatewayRouteTablePropagation withTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
        setTransitGatewayAttachmentId(transitGatewayAttachmentId);
        return this;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @param resourceId
     *        The ID of the resource.
     */

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */

    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @param resourceId
     *        The ID of the resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransitGatewayRouteTablePropagation withResourceId(String resourceId) {
        setResourceId(resourceId);
        return this;
    }

    /**
     * <p>
     * The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * 
     * @param resourceType
     *        The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @see TransitGatewayAttachmentResourceType
     */

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * <p>
     * The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * 
     * @return The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @see TransitGatewayAttachmentResourceType
     */

    public String getResourceType() {
        return this.resourceType;
    }

    /**
     * <p>
     * The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * 
     * @param resourceType
     *        The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransitGatewayAttachmentResourceType
     */

    public TransitGatewayRouteTablePropagation withResourceType(String resourceType) {
        setResourceType(resourceType);
        return this;
    }

    /**
     * <p>
     * The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * 
     * @param resourceType
     *        The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransitGatewayAttachmentResourceType
     */

    public TransitGatewayRouteTablePropagation withResourceType(TransitGatewayAttachmentResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    /**
     * <p>
     * The state of the resource.
     * </p>
     * 
     * @param state
     *        The state of the resource.
     * @see TransitGatewayPropagationState
     */

    public void setState(String state) {
        this.state = state;
    }

    /**
     * <p>
     * The state of the resource.
     * </p>
     * 
     * @return The state of the resource.
     * @see TransitGatewayPropagationState
     */

    public String getState() {
        return this.state;
    }

    /**
     * <p>
     * The state of the resource.
     * </p>
     * 
     * @param state
     *        The state of the resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransitGatewayPropagationState
     */

    public TransitGatewayRouteTablePropagation withState(String state) {
        setState(state);
        return this;
    }

    /**
     * <p>
     * The state of the resource.
     * </p>
     * 
     * @param state
     *        The state of the resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransitGatewayPropagationState
     */

    public TransitGatewayRouteTablePropagation withState(TransitGatewayPropagationState state) {
        this.state = state.toString();
        return this;
    }

    /**
     * <p>
     * The ID of the transit gateway route table announcement.
     * </p>
     * 
     * @param transitGatewayRouteTableAnnouncementId
     *        The ID of the transit gateway route table announcement.
     */

    public void setTransitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
        this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
    }

    /**
     * <p>
     * The ID of the transit gateway route table announcement.
     * </p>
     * 
     * @return The ID of the transit gateway route table announcement.
     */

    public String getTransitGatewayRouteTableAnnouncementId() {
        return this.transitGatewayRouteTableAnnouncementId;
    }

    /**
     * <p>
     * The ID of the transit gateway route table announcement.
     * </p>
     * 
     * @param transitGatewayRouteTableAnnouncementId
     *        The ID of the transit gateway route table announcement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransitGatewayRouteTablePropagation withTransitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
        setTransitGatewayRouteTableAnnouncementId(transitGatewayRouteTableAnnouncementId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTransitGatewayAttachmentId() != null)
            sb.append("TransitGatewayAttachmentId: ").append(getTransitGatewayAttachmentId()).append(",");
        if (getResourceId() != null)
            sb.append("ResourceId: ").append(getResourceId()).append(",");
        if (getResourceType() != null)
            sb.append("ResourceType: ").append(getResourceType()).append(",");
        if (getState() != null)
            sb.append("State: ").append(getState()).append(",");
        if (getTransitGatewayRouteTableAnnouncementId() != null)
            sb.append("TransitGatewayRouteTableAnnouncementId: ").append(getTransitGatewayRouteTableAnnouncementId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TransitGatewayRouteTablePropagation == false)
            return false;
        TransitGatewayRouteTablePropagation other = (TransitGatewayRouteTablePropagation) obj;
        if (other.getTransitGatewayAttachmentId() == null ^ this.getTransitGatewayAttachmentId() == null)
            return false;
        if (other.getTransitGatewayAttachmentId() != null && other.getTransitGatewayAttachmentId().equals(this.getTransitGatewayAttachmentId()) == false)
            return false;
        if (other.getResourceId() == null ^ this.getResourceId() == null)
            return false;
        if (other.getResourceId() != null && other.getResourceId().equals(this.getResourceId()) == false)
            return false;
        if (other.getResourceType() == null ^ this.getResourceType() == null)
            return false;
        if (other.getResourceType() != null && other.getResourceType().equals(this.getResourceType()) == false)
            return false;
        if (other.getState() == null ^ this.getState() == null)
            return false;
        if (other.getState() != null && other.getState().equals(this.getState()) == false)
            return false;
        if (other.getTransitGatewayRouteTableAnnouncementId() == null ^ this.getTransitGatewayRouteTableAnnouncementId() == null)
            return false;
        if (other.getTransitGatewayRouteTableAnnouncementId() != null
                && other.getTransitGatewayRouteTableAnnouncementId().equals(this.getTransitGatewayRouteTableAnnouncementId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTransitGatewayAttachmentId() == null) ? 0 : getTransitGatewayAttachmentId().hashCode());
        hashCode = prime * hashCode + ((getResourceId() == null) ? 0 : getResourceId().hashCode());
        hashCode = prime * hashCode + ((getResourceType() == null) ? 0 : getResourceType().hashCode());
        hashCode = prime * hashCode + ((getState() == null) ? 0 : getState().hashCode());
        hashCode = prime * hashCode + ((getTransitGatewayRouteTableAnnouncementId() == null) ? 0 : getTransitGatewayRouteTableAnnouncementId().hashCode());
        return hashCode;
    }

    @Override
    public TransitGatewayRouteTablePropagation clone() {
        try {
            return (TransitGatewayRouteTablePropagation) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
