/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.transform.DescribeIpamResourceDiscoveryAssociationsRequestMarshaller;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeIpamResourceDiscoveryAssociationsRequest extends AmazonWebServiceRequest implements Serializable, Cloneable,
        DryRunSupportedRequest<DescribeIpamResourceDiscoveryAssociationsRequest> {

    /**
     * <p>
     * The resource discovery association IDs.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> ipamResourceDiscoveryAssociationIds;
    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of resource discovery associations to return in one page of results.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * The resource discovery association filters.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Filter> filters;

    /**
     * <p>
     * The resource discovery association IDs.
     * </p>
     * 
     * @return The resource discovery association IDs.
     */

    public java.util.List<String> getIpamResourceDiscoveryAssociationIds() {
        if (ipamResourceDiscoveryAssociationIds == null) {
            ipamResourceDiscoveryAssociationIds = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return ipamResourceDiscoveryAssociationIds;
    }

    /**
     * <p>
     * The resource discovery association IDs.
     * </p>
     * 
     * @param ipamResourceDiscoveryAssociationIds
     *        The resource discovery association IDs.
     */

    public void setIpamResourceDiscoveryAssociationIds(java.util.Collection<String> ipamResourceDiscoveryAssociationIds) {
        if (ipamResourceDiscoveryAssociationIds == null) {
            this.ipamResourceDiscoveryAssociationIds = null;
            return;
        }

        this.ipamResourceDiscoveryAssociationIds = new com.amazonaws.internal.SdkInternalList<String>(ipamResourceDiscoveryAssociationIds);
    }

    /**
     * <p>
     * The resource discovery association IDs.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIpamResourceDiscoveryAssociationIds(java.util.Collection)} or
     * {@link #withIpamResourceDiscoveryAssociationIds(java.util.Collection)} if you want to override the existing
     * values.
     * </p>
     * 
     * @param ipamResourceDiscoveryAssociationIds
     *        The resource discovery association IDs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamResourceDiscoveryAssociationsRequest withIpamResourceDiscoveryAssociationIds(String... ipamResourceDiscoveryAssociationIds) {
        if (this.ipamResourceDiscoveryAssociationIds == null) {
            setIpamResourceDiscoveryAssociationIds(new com.amazonaws.internal.SdkInternalList<String>(ipamResourceDiscoveryAssociationIds.length));
        }
        for (String ele : ipamResourceDiscoveryAssociationIds) {
            this.ipamResourceDiscoveryAssociationIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The resource discovery association IDs.
     * </p>
     * 
     * @param ipamResourceDiscoveryAssociationIds
     *        The resource discovery association IDs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamResourceDiscoveryAssociationsRequest withIpamResourceDiscoveryAssociationIds(
            java.util.Collection<String> ipamResourceDiscoveryAssociationIds) {
        setIpamResourceDiscoveryAssociationIds(ipamResourceDiscoveryAssociationIds);
        return this;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @param nextToken
     *        Specify the pagination token from a previous request to retrieve the next page of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @param nextToken
     *        Specify the pagination token from a previous request to retrieve the next page of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamResourceDiscoveryAssociationsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of resource discovery associations to return in one page of results.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of resource discovery associations to return in one page of results.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of resource discovery associations to return in one page of results.
     * </p>
     * 
     * @return The maximum number of resource discovery associations to return in one page of results.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of resource discovery associations to return in one page of results.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of resource discovery associations to return in one page of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamResourceDiscoveryAssociationsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The resource discovery association filters.
     * </p>
     * 
     * @return The resource discovery association filters.
     */

    public java.util.List<Filter> getFilters() {
        if (filters == null) {
            filters = new com.amazonaws.internal.SdkInternalList<Filter>();
        }
        return filters;
    }

    /**
     * <p>
     * The resource discovery association filters.
     * </p>
     * 
     * @param filters
     *        The resource discovery association filters.
     */

    public void setFilters(java.util.Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }

        this.filters = new com.amazonaws.internal.SdkInternalList<Filter>(filters);
    }

    /**
     * <p>
     * The resource discovery association filters.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param filters
     *        The resource discovery association filters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamResourceDiscoveryAssociationsRequest withFilters(Filter... filters) {
        if (this.filters == null) {
            setFilters(new com.amazonaws.internal.SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The resource discovery association filters.
     * </p>
     * 
     * @param filters
     *        The resource discovery association filters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamResourceDiscoveryAssociationsRequest withFilters(java.util.Collection<Filter> filters) {
        setFilters(filters);
        return this;
    }

    /**
     * This method is intended for internal use only. Returns the marshaled request configured with additional
     * parameters to enable operation dry-run.
     */
    @Override
    public Request<DescribeIpamResourceDiscoveryAssociationsRequest> getDryRunRequest() {
        Request<DescribeIpamResourceDiscoveryAssociationsRequest> request = new DescribeIpamResourceDiscoveryAssociationsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIpamResourceDiscoveryAssociationIds() != null)
            sb.append("IpamResourceDiscoveryAssociationIds: ").append(getIpamResourceDiscoveryAssociationIds()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getFilters() != null)
            sb.append("Filters: ").append(getFilters());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeIpamResourceDiscoveryAssociationsRequest == false)
            return false;
        DescribeIpamResourceDiscoveryAssociationsRequest other = (DescribeIpamResourceDiscoveryAssociationsRequest) obj;
        if (other.getIpamResourceDiscoveryAssociationIds() == null ^ this.getIpamResourceDiscoveryAssociationIds() == null)
            return false;
        if (other.getIpamResourceDiscoveryAssociationIds() != null
                && other.getIpamResourceDiscoveryAssociationIds().equals(this.getIpamResourceDiscoveryAssociationIds()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getFilters() == null ^ this.getFilters() == null)
            return false;
        if (other.getFilters() != null && other.getFilters().equals(this.getFilters()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIpamResourceDiscoveryAssociationIds() == null) ? 0 : getIpamResourceDiscoveryAssociationIds().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getFilters() == null) ? 0 : getFilters().hashCode());
        return hashCode;
    }

    @Override
    public DescribeIpamResourceDiscoveryAssociationsRequest clone() {
        return (DescribeIpamResourceDiscoveryAssociationsRequest) super.clone();
    }
}
