/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AsnAuthorizationContext;
import com.amazonaws.services.ec2.model.ProvisionIpamByoasnRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ProvisionIpamByoasnRequestMarshaller
implements Marshaller<Request<ProvisionIpamByoasnRequest>, ProvisionIpamByoasnRequest> {
    public Request<ProvisionIpamByoasnRequest> marshall(ProvisionIpamByoasnRequest provisionIpamByoasnRequest) {
        AsnAuthorizationContext asnAuthorizationContext;
        if (provisionIpamByoasnRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)provisionIpamByoasnRequest, "AmazonEC2");
        request.addParameter("Action", "ProvisionIpamByoasn");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (provisionIpamByoasnRequest.getIpamId() != null) {
            request.addParameter("IpamId", StringUtils.fromString((String)provisionIpamByoasnRequest.getIpamId()));
        }
        if (provisionIpamByoasnRequest.getAsn() != null) {
            request.addParameter("Asn", StringUtils.fromString((String)provisionIpamByoasnRequest.getAsn()));
        }
        if ((asnAuthorizationContext = provisionIpamByoasnRequest.getAsnAuthorizationContext()) != null) {
            if (asnAuthorizationContext.getMessage() != null) {
                request.addParameter("AsnAuthorizationContext.Message", StringUtils.fromString((String)asnAuthorizationContext.getMessage()));
            }
            if (asnAuthorizationContext.getSignature() != null) {
                request.addParameter("AsnAuthorizationContext.Signature", StringUtils.fromString((String)asnAuthorizationContext.getSignature()));
            }
        }
        return request;
    }
}

