/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PrivateDnsDetails;
import com.amazonaws.services.ec2.model.ServiceDetail;
import com.amazonaws.services.ec2.model.ServiceTypeDetail;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.PrivateDnsDetailsStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ServiceTypeDetailStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ServiceDetailStaxUnmarshaller
implements Unmarshaller<ServiceDetail, StaxUnmarshallerContext> {
    private static ServiceDetailStaxUnmarshaller instance;

    public ServiceDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        ServiceDetail serviceDetail = new ServiceDetail();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return serviceDetail;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("serviceName", targetDepth)) {
                    serviceDetail.setServiceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("serviceId", targetDepth)) {
                    serviceDetail.setServiceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("serviceType", targetDepth)) {
                    serviceDetail.withServiceType(new ArrayList<ServiceTypeDetail>());
                    continue;
                }
                if (context.testExpression("serviceType/item", targetDepth)) {
                    serviceDetail.withServiceType(ServiceTypeDetailStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZoneSet", targetDepth)) {
                    serviceDetail.withAvailabilityZones(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("availabilityZoneSet/item", targetDepth)) {
                    serviceDetail.withAvailabilityZones(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("owner", targetDepth)) {
                    serviceDetail.setOwner(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("baseEndpointDnsNameSet", targetDepth)) {
                    serviceDetail.withBaseEndpointDnsNames(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("baseEndpointDnsNameSet/item", targetDepth)) {
                    serviceDetail.withBaseEndpointDnsNames(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateDnsName", targetDepth)) {
                    serviceDetail.setPrivateDnsName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateDnsNameSet", targetDepth)) {
                    serviceDetail.withPrivateDnsNames(new ArrayList<PrivateDnsDetails>());
                    continue;
                }
                if (context.testExpression("privateDnsNameSet/item", targetDepth)) {
                    serviceDetail.withPrivateDnsNames(PrivateDnsDetailsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcEndpointPolicySupported", targetDepth)) {
                    serviceDetail.setVpcEndpointPolicySupported(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("acceptanceRequired", targetDepth)) {
                    serviceDetail.setAcceptanceRequired(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("managesVpcEndpoints", targetDepth)) {
                    serviceDetail.setManagesVpcEndpoints(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("payerResponsibility", targetDepth)) {
                    serviceDetail.setPayerResponsibility(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    serviceDetail.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    serviceDetail.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateDnsNameVerificationState", targetDepth)) {
                    serviceDetail.setPrivateDnsNameVerificationState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("supportedIpAddressTypeSet", targetDepth)) {
                    serviceDetail.withSupportedIpAddressTypes(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("supportedIpAddressTypeSet/item", targetDepth)) continue;
                serviceDetail.withSupportedIpAddressTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return serviceDetail;
    }

    public static ServiceDetailStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceDetailStaxUnmarshaller();
        }
        return instance;
    }
}

