/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyTransitGatewayOptions;
import com.amazonaws.services.ec2.model.ModifyTransitGatewayRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyTransitGatewayRequestMarshaller
implements Marshaller<Request<ModifyTransitGatewayRequest>, ModifyTransitGatewayRequest> {
    public Request<ModifyTransitGatewayRequest> marshall(ModifyTransitGatewayRequest modifyTransitGatewayRequest) {
        ModifyTransitGatewayOptions options;
        if (modifyTransitGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyTransitGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyTransitGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTransitGatewayRequest.getTransitGatewayId() != null) {
            request.addParameter("TransitGatewayId", StringUtils.fromString((String)modifyTransitGatewayRequest.getTransitGatewayId()));
        }
        if (modifyTransitGatewayRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyTransitGatewayRequest.getDescription()));
        }
        if ((options = modifyTransitGatewayRequest.getOptions()) != null) {
            SdkInternalList modifyTransitGatewayOptionsRemoveTransitGatewayCidrBlocksList;
            SdkInternalList modifyTransitGatewayOptionsAddTransitGatewayCidrBlocksList = (SdkInternalList)options.getAddTransitGatewayCidrBlocks();
            if (!modifyTransitGatewayOptionsAddTransitGatewayCidrBlocksList.isEmpty() || !modifyTransitGatewayOptionsAddTransitGatewayCidrBlocksList.isAutoConstruct()) {
                int addTransitGatewayCidrBlocksListIndex = 1;
                for (String modifyTransitGatewayOptionsAddTransitGatewayCidrBlocksListValue : modifyTransitGatewayOptionsAddTransitGatewayCidrBlocksList) {
                    if (modifyTransitGatewayOptionsAddTransitGatewayCidrBlocksListValue != null) {
                        request.addParameter("Options.AddTransitGatewayCidrBlocks." + addTransitGatewayCidrBlocksListIndex, StringUtils.fromString((String)modifyTransitGatewayOptionsAddTransitGatewayCidrBlocksListValue));
                    }
                    ++addTransitGatewayCidrBlocksListIndex;
                }
            }
            if (!(modifyTransitGatewayOptionsRemoveTransitGatewayCidrBlocksList = (SdkInternalList)options.getRemoveTransitGatewayCidrBlocks()).isEmpty() || !modifyTransitGatewayOptionsRemoveTransitGatewayCidrBlocksList.isAutoConstruct()) {
                int removeTransitGatewayCidrBlocksListIndex = 1;
                for (String modifyTransitGatewayOptionsRemoveTransitGatewayCidrBlocksListValue : modifyTransitGatewayOptionsRemoveTransitGatewayCidrBlocksList) {
                    if (modifyTransitGatewayOptionsRemoveTransitGatewayCidrBlocksListValue != null) {
                        request.addParameter("Options.RemoveTransitGatewayCidrBlocks." + removeTransitGatewayCidrBlocksListIndex, StringUtils.fromString((String)modifyTransitGatewayOptionsRemoveTransitGatewayCidrBlocksListValue));
                    }
                    ++removeTransitGatewayCidrBlocksListIndex;
                }
            }
            if (options.getVpnEcmpSupport() != null) {
                request.addParameter("Options.VpnEcmpSupport", StringUtils.fromString((String)options.getVpnEcmpSupport()));
            }
            if (options.getDnsSupport() != null) {
                request.addParameter("Options.DnsSupport", StringUtils.fromString((String)options.getDnsSupport()));
            }
            if (options.getSecurityGroupReferencingSupport() != null) {
                request.addParameter("Options.SecurityGroupReferencingSupport", StringUtils.fromString((String)options.getSecurityGroupReferencingSupport()));
            }
            if (options.getAutoAcceptSharedAttachments() != null) {
                request.addParameter("Options.AutoAcceptSharedAttachments", StringUtils.fromString((String)options.getAutoAcceptSharedAttachments()));
            }
            if (options.getDefaultRouteTableAssociation() != null) {
                request.addParameter("Options.DefaultRouteTableAssociation", StringUtils.fromString((String)options.getDefaultRouteTableAssociation()));
            }
            if (options.getAssociationDefaultRouteTableId() != null) {
                request.addParameter("Options.AssociationDefaultRouteTableId", StringUtils.fromString((String)options.getAssociationDefaultRouteTableId()));
            }
            if (options.getDefaultRouteTablePropagation() != null) {
                request.addParameter("Options.DefaultRouteTablePropagation", StringUtils.fromString((String)options.getDefaultRouteTablePropagation()));
            }
            if (options.getPropagationDefaultRouteTableId() != null) {
                request.addParameter("Options.PropagationDefaultRouteTableId", StringUtils.fromString((String)options.getPropagationDefaultRouteTableId()));
            }
            if (options.getAmazonSideAsn() != null) {
                request.addParameter("Options.AmazonSideAsn", StringUtils.fromLong((Long)options.getAmazonSideAsn()));
            }
        }
        return request;
    }
}

