/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DisassociateInstanceEventWindowRequest;
import com.amazonaws.services.ec2.model.InstanceEventWindowDisassociationRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DisassociateInstanceEventWindowRequestMarshaller
implements Marshaller<Request<DisassociateInstanceEventWindowRequest>, DisassociateInstanceEventWindowRequest> {
    public Request<DisassociateInstanceEventWindowRequest> marshall(DisassociateInstanceEventWindowRequest disassociateInstanceEventWindowRequest) {
        InstanceEventWindowDisassociationRequest associationTarget;
        if (disassociateInstanceEventWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disassociateInstanceEventWindowRequest, "AmazonEC2");
        request.addParameter("Action", "DisassociateInstanceEventWindow");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (disassociateInstanceEventWindowRequest.getInstanceEventWindowId() != null) {
            request.addParameter("InstanceEventWindowId", StringUtils.fromString((String)disassociateInstanceEventWindowRequest.getInstanceEventWindowId()));
        }
        if ((associationTarget = disassociateInstanceEventWindowRequest.getAssociationTarget()) != null) {
            SdkInternalList instanceEventWindowDisassociationRequestDedicatedHostIdsList;
            SdkInternalList instanceEventWindowDisassociationRequestInstanceTagsList;
            SdkInternalList instanceEventWindowDisassociationRequestInstanceIdsList = (SdkInternalList)associationTarget.getInstanceIds();
            if (!instanceEventWindowDisassociationRequestInstanceIdsList.isEmpty() || !instanceEventWindowDisassociationRequestInstanceIdsList.isAutoConstruct()) {
                int instanceIdsListIndex = 1;
                for (Object instanceEventWindowDisassociationRequestInstanceIdsListValue : instanceEventWindowDisassociationRequestInstanceIdsList) {
                    if (instanceEventWindowDisassociationRequestInstanceIdsListValue != null) {
                        request.addParameter("AssociationTarget.InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)instanceEventWindowDisassociationRequestInstanceIdsListValue));
                    }
                    ++instanceIdsListIndex;
                }
            }
            if (!(instanceEventWindowDisassociationRequestInstanceTagsList = (SdkInternalList)associationTarget.getInstanceTags()).isEmpty() || !instanceEventWindowDisassociationRequestInstanceTagsList.isAutoConstruct()) {
                int instanceTagsListIndex = 1;
                for (Tag instanceEventWindowDisassociationRequestInstanceTagsListValue : instanceEventWindowDisassociationRequestInstanceTagsList) {
                    if (instanceEventWindowDisassociationRequestInstanceTagsListValue.getKey() != null) {
                        request.addParameter("AssociationTarget.InstanceTag." + instanceTagsListIndex + ".Key", StringUtils.fromString((String)instanceEventWindowDisassociationRequestInstanceTagsListValue.getKey()));
                    }
                    if (instanceEventWindowDisassociationRequestInstanceTagsListValue.getValue() != null) {
                        request.addParameter("AssociationTarget.InstanceTag." + instanceTagsListIndex + ".Value", StringUtils.fromString((String)instanceEventWindowDisassociationRequestInstanceTagsListValue.getValue()));
                    }
                    ++instanceTagsListIndex;
                }
            }
            if (!(instanceEventWindowDisassociationRequestDedicatedHostIdsList = (SdkInternalList)associationTarget.getDedicatedHostIds()).isEmpty() || !instanceEventWindowDisassociationRequestDedicatedHostIdsList.isAutoConstruct()) {
                int dedicatedHostIdsListIndex = 1;
                for (String instanceEventWindowDisassociationRequestDedicatedHostIdsListValue : instanceEventWindowDisassociationRequestDedicatedHostIdsList) {
                    if (instanceEventWindowDisassociationRequestDedicatedHostIdsListValue != null) {
                        request.addParameter("AssociationTarget.DedicatedHostId." + dedicatedHostIdsListIndex, StringUtils.fromString((String)instanceEventWindowDisassociationRequestDedicatedHostIdsListValue));
                    }
                    ++dedicatedHostIdsListIndex;
                }
            }
        }
        return request;
    }
}

