/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateIpamPoolRequest;
import com.amazonaws.services.ec2.model.RequestIpamResourceTag;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateIpamPoolRequestMarshaller
implements Marshaller<Request<CreateIpamPoolRequest>, CreateIpamPoolRequest> {
    public Request<CreateIpamPoolRequest> marshall(CreateIpamPoolRequest createIpamPoolRequest) {
        SdkInternalList createIpamPoolRequestTagSpecificationsList;
        SdkInternalList createIpamPoolRequestAllocationResourceTagsList;
        if (createIpamPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIpamPoolRequest, "AmazonEC2");
        request.addParameter("Action", "CreateIpamPool");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createIpamPoolRequest.getIpamScopeId() != null) {
            request.addParameter("IpamScopeId", StringUtils.fromString((String)createIpamPoolRequest.getIpamScopeId()));
        }
        if (createIpamPoolRequest.getLocale() != null) {
            request.addParameter("Locale", StringUtils.fromString((String)createIpamPoolRequest.getLocale()));
        }
        if (createIpamPoolRequest.getSourceIpamPoolId() != null) {
            request.addParameter("SourceIpamPoolId", StringUtils.fromString((String)createIpamPoolRequest.getSourceIpamPoolId()));
        }
        if (createIpamPoolRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createIpamPoolRequest.getDescription()));
        }
        if (createIpamPoolRequest.getAddressFamily() != null) {
            request.addParameter("AddressFamily", StringUtils.fromString((String)createIpamPoolRequest.getAddressFamily()));
        }
        if (createIpamPoolRequest.getAutoImport() != null) {
            request.addParameter("AutoImport", StringUtils.fromBoolean((Boolean)createIpamPoolRequest.getAutoImport()));
        }
        if (createIpamPoolRequest.getPubliclyAdvertisable() != null) {
            request.addParameter("PubliclyAdvertisable", StringUtils.fromBoolean((Boolean)createIpamPoolRequest.getPubliclyAdvertisable()));
        }
        if (createIpamPoolRequest.getAllocationMinNetmaskLength() != null) {
            request.addParameter("AllocationMinNetmaskLength", StringUtils.fromInteger((Integer)createIpamPoolRequest.getAllocationMinNetmaskLength()));
        }
        if (createIpamPoolRequest.getAllocationMaxNetmaskLength() != null) {
            request.addParameter("AllocationMaxNetmaskLength", StringUtils.fromInteger((Integer)createIpamPoolRequest.getAllocationMaxNetmaskLength()));
        }
        if (createIpamPoolRequest.getAllocationDefaultNetmaskLength() != null) {
            request.addParameter("AllocationDefaultNetmaskLength", StringUtils.fromInteger((Integer)createIpamPoolRequest.getAllocationDefaultNetmaskLength()));
        }
        if (!(createIpamPoolRequestAllocationResourceTagsList = (SdkInternalList)createIpamPoolRequest.getAllocationResourceTags()).isEmpty() || !createIpamPoolRequestAllocationResourceTagsList.isAutoConstruct()) {
            int allocationResourceTagsListIndex = 1;
            for (RequestIpamResourceTag createIpamPoolRequestAllocationResourceTagsListValue : createIpamPoolRequestAllocationResourceTagsList) {
                if (createIpamPoolRequestAllocationResourceTagsListValue.getKey() != null) {
                    request.addParameter("AllocationResourceTag." + allocationResourceTagsListIndex + ".Key", StringUtils.fromString((String)createIpamPoolRequestAllocationResourceTagsListValue.getKey()));
                }
                if (createIpamPoolRequestAllocationResourceTagsListValue.getValue() != null) {
                    request.addParameter("AllocationResourceTag." + allocationResourceTagsListIndex + ".Value", StringUtils.fromString((String)createIpamPoolRequestAllocationResourceTagsListValue.getValue()));
                }
                ++allocationResourceTagsListIndex;
            }
        }
        if (!(createIpamPoolRequestTagSpecificationsList = (SdkInternalList)createIpamPoolRequest.getTagSpecifications()).isEmpty() || !createIpamPoolRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createIpamPoolRequestTagSpecificationsListValue : createIpamPoolRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createIpamPoolRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createIpamPoolRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createIpamPoolRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createIpamPoolRequest.getClientToken()));
        if (createIpamPoolRequest.getAwsService() != null) {
            request.addParameter("AwsService", StringUtils.fromString((String)createIpamPoolRequest.getAwsService()));
        }
        if (createIpamPoolRequest.getPublicIpSource() != null) {
            request.addParameter("PublicIpSource", StringUtils.fromString((String)createIpamPoolRequest.getPublicIpSource()));
        }
        return request;
    }
}

