/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceleratorCountRequest;
import com.amazonaws.services.ec2.model.AcceleratorTotalMemoryMiBRequest;
import com.amazonaws.services.ec2.model.BaselineEbsBandwidthMbpsRequest;
import com.amazonaws.services.ec2.model.CapacityReservationOptionsRequest;
import com.amazonaws.services.ec2.model.CreateFleetRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import com.amazonaws.services.ec2.model.FleetSpotCapacityRebalanceRequest;
import com.amazonaws.services.ec2.model.FleetSpotMaintenanceStrategiesRequest;
import com.amazonaws.services.ec2.model.InstanceRequirementsRequest;
import com.amazonaws.services.ec2.model.MemoryGiBPerVCpuRequest;
import com.amazonaws.services.ec2.model.MemoryMiBRequest;
import com.amazonaws.services.ec2.model.NetworkBandwidthGbpsRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceCountRequest;
import com.amazonaws.services.ec2.model.OnDemandOptionsRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.SpotOptionsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.amazonaws.services.ec2.model.TotalLocalStorageGBRequest;
import com.amazonaws.services.ec2.model.VCpuCountRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        SdkInternalList createFleetRequestTagSpecificationsList;
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        SdkInternalList createFleetRequestLaunchTemplateConfigsList;
        OnDemandOptionsRequest onDemandOptions;
        SpotOptionsRequest spotOptions;
        if (createFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFleetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFleetRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createFleetRequest.getClientToken()));
        }
        if ((spotOptions = createFleetRequest.getSpotOptions()) != null) {
            FleetSpotCapacityRebalanceRequest capacityRebalance;
            FleetSpotMaintenanceStrategiesRequest maintenanceStrategies;
            if (spotOptions.getAllocationStrategy() != null) {
                request.addParameter("SpotOptions.AllocationStrategy", StringUtils.fromString((String)spotOptions.getAllocationStrategy()));
            }
            if ((maintenanceStrategies = spotOptions.getMaintenanceStrategies()) != null && (capacityRebalance = maintenanceStrategies.getCapacityRebalance()) != null) {
                if (capacityRebalance.getReplacementStrategy() != null) {
                    request.addParameter("SpotOptions.MaintenanceStrategies.CapacityRebalance.ReplacementStrategy", StringUtils.fromString((String)capacityRebalance.getReplacementStrategy()));
                }
                if (capacityRebalance.getTerminationDelay() != null) {
                    request.addParameter("SpotOptions.MaintenanceStrategies.CapacityRebalance.TerminationDelay", StringUtils.fromInteger((Integer)capacityRebalance.getTerminationDelay()));
                }
            }
            if (spotOptions.getInstanceInterruptionBehavior() != null) {
                request.addParameter("SpotOptions.InstanceInterruptionBehavior", StringUtils.fromString((String)spotOptions.getInstanceInterruptionBehavior()));
            }
            if (spotOptions.getInstancePoolsToUseCount() != null) {
                request.addParameter("SpotOptions.InstancePoolsToUseCount", StringUtils.fromInteger((Integer)spotOptions.getInstancePoolsToUseCount()));
            }
            if (spotOptions.getSingleInstanceType() != null) {
                request.addParameter("SpotOptions.SingleInstanceType", StringUtils.fromBoolean((Boolean)spotOptions.getSingleInstanceType()));
            }
            if (spotOptions.getSingleAvailabilityZone() != null) {
                request.addParameter("SpotOptions.SingleAvailabilityZone", StringUtils.fromBoolean((Boolean)spotOptions.getSingleAvailabilityZone()));
            }
            if (spotOptions.getMinTargetCapacity() != null) {
                request.addParameter("SpotOptions.MinTargetCapacity", StringUtils.fromInteger((Integer)spotOptions.getMinTargetCapacity()));
            }
            if (spotOptions.getMaxTotalPrice() != null) {
                request.addParameter("SpotOptions.MaxTotalPrice", StringUtils.fromString((String)spotOptions.getMaxTotalPrice()));
            }
        }
        if ((onDemandOptions = createFleetRequest.getOnDemandOptions()) != null) {
            CapacityReservationOptionsRequest capacityReservationOptions;
            if (onDemandOptions.getAllocationStrategy() != null) {
                request.addParameter("OnDemandOptions.AllocationStrategy", StringUtils.fromString((String)onDemandOptions.getAllocationStrategy()));
            }
            if ((capacityReservationOptions = onDemandOptions.getCapacityReservationOptions()) != null && capacityReservationOptions.getUsageStrategy() != null) {
                request.addParameter("OnDemandOptions.CapacityReservationOptions.UsageStrategy", StringUtils.fromString((String)capacityReservationOptions.getUsageStrategy()));
            }
            if (onDemandOptions.getSingleInstanceType() != null) {
                request.addParameter("OnDemandOptions.SingleInstanceType", StringUtils.fromBoolean((Boolean)onDemandOptions.getSingleInstanceType()));
            }
            if (onDemandOptions.getSingleAvailabilityZone() != null) {
                request.addParameter("OnDemandOptions.SingleAvailabilityZone", StringUtils.fromBoolean((Boolean)onDemandOptions.getSingleAvailabilityZone()));
            }
            if (onDemandOptions.getMinTargetCapacity() != null) {
                request.addParameter("OnDemandOptions.MinTargetCapacity", StringUtils.fromInteger((Integer)onDemandOptions.getMinTargetCapacity()));
            }
            if (onDemandOptions.getMaxTotalPrice() != null) {
                request.addParameter("OnDemandOptions.MaxTotalPrice", StringUtils.fromString((String)onDemandOptions.getMaxTotalPrice()));
            }
        }
        if (createFleetRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString((String)createFleetRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(createFleetRequestLaunchTemplateConfigsList = (SdkInternalList)createFleetRequest.getLaunchTemplateConfigs()).isEmpty() || !createFleetRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (FleetLaunchTemplateConfigRequest createFleetRequestLaunchTemplateConfigsListValue : createFleetRequestLaunchTemplateConfigsList) {
                SdkInternalList fleetLaunchTemplateConfigRequestOverridesList;
                FleetLaunchTemplateSpecificationRequest launchTemplateSpecification = createFleetRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(fleetLaunchTemplateConfigRequestOverridesList = (SdkInternalList)createFleetRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !fleetLaunchTemplateConfigRequestOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (FleetLaunchTemplateOverridesRequest fleetLaunchTemplateConfigRequestOverridesListValue : fleetLaunchTemplateConfigRequestOverridesList) {
                        InstanceRequirementsRequest instanceRequirements;
                        Placement placement;
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".MaxPrice", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getPriority()));
                        }
                        if ((placement = fleetLaunchTemplateConfigRequestOverridesListValue.getPlacement()) != null) {
                            if (placement.getAvailabilityZone() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                            }
                            if (placement.getAffinity() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
                            }
                            if (placement.getGroupName() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                            }
                            if (placement.getPartitionNumber() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.PartitionNumber", StringUtils.fromInteger((Integer)placement.getPartitionNumber()));
                            }
                            if (placement.getHostId() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
                            }
                            if (placement.getTenancy() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                            }
                            if (placement.getSpreadDomain() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.SpreadDomain", StringUtils.fromString((String)placement.getSpreadDomain()));
                            }
                            if (placement.getHostResourceGroupArn() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostResourceGroupArn", StringUtils.fromString((String)placement.getHostResourceGroupArn()));
                            }
                            if (placement.getGroupId() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.GroupId", StringUtils.fromString((String)placement.getGroupId()));
                            }
                        }
                        if ((instanceRequirements = fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceRequirements()) != null) {
                            SdkInternalList instanceRequirementsRequestAllowedInstanceTypesList;
                            NetworkBandwidthGbpsRequest networkBandwidthGbps;
                            AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB;
                            SdkInternalList instanceRequirementsRequestAcceleratorNamesList;
                            SdkInternalList instanceRequirementsRequestAcceleratorManufacturersList;
                            AcceleratorCountRequest acceleratorCount;
                            SdkInternalList instanceRequirementsRequestAcceleratorTypesList;
                            BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps;
                            TotalLocalStorageGBRequest totalLocalStorageGB;
                            SdkInternalList instanceRequirementsRequestLocalStorageTypesList;
                            NetworkInterfaceCountRequest networkInterfaceCount;
                            SdkInternalList instanceRequirementsRequestInstanceGenerationsList;
                            SdkInternalList instanceRequirementsRequestExcludedInstanceTypesList;
                            MemoryGiBPerVCpuRequest memoryGiBPerVCpu;
                            SdkInternalList instanceRequirementsRequestCpuManufacturersList;
                            MemoryMiBRequest memoryMiB;
                            VCpuCountRangeRequest vCpuCount = instanceRequirements.getVCpuCount();
                            if (vCpuCount != null) {
                                if (vCpuCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                                }
                                if (vCpuCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                                }
                            }
                            if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                                if (memoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                                }
                                if (memoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsRequestCpuManufacturersList.isAutoConstruct()) {
                                int cpuManufacturersListIndex = 1;
                                for (String instanceRequirementsRequestCpuManufacturersListValue : instanceRequirementsRequestCpuManufacturersList) {
                                    if (instanceRequirementsRequestCpuManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.CpuManufacturer." + cpuManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestCpuManufacturersListValue));
                                    }
                                    ++cpuManufacturersListIndex;
                                }
                            }
                            if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                                if (memoryGiBPerVCpu.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                                }
                                if (memoryGiBPerVCpu.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsRequestExcludedInstanceTypesList.isAutoConstruct()) {
                                int excludedInstanceTypesListIndex = 1;
                                for (Object instanceRequirementsRequestExcludedInstanceTypesListValue : instanceRequirementsRequestExcludedInstanceTypesList) {
                                    if (instanceRequirementsRequestExcludedInstanceTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.ExcludedInstanceType." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestExcludedInstanceTypesListValue));
                                    }
                                    ++excludedInstanceTypesListIndex;
                                }
                            }
                            if (!(instanceRequirementsRequestInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsRequestInstanceGenerationsList.isAutoConstruct()) {
                                Object instanceRequirementsRequestExcludedInstanceTypesListValue;
                                int instanceGenerationsListIndex = 1;
                                instanceRequirementsRequestExcludedInstanceTypesListValue = instanceRequirementsRequestInstanceGenerationsList.iterator();
                                while (instanceRequirementsRequestExcludedInstanceTypesListValue.hasNext()) {
                                    String instanceRequirementsRequestInstanceGenerationsListValue = (String)instanceRequirementsRequestExcludedInstanceTypesListValue.next();
                                    if (instanceRequirementsRequestInstanceGenerationsListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.InstanceGeneration." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceRequirementsRequestInstanceGenerationsListValue));
                                    }
                                    ++instanceGenerationsListIndex;
                                }
                            }
                            if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getBareMetal() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                            }
                            if (instanceRequirements.getBurstablePerformance() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                            }
                            if (instanceRequirements.getRequireHibernateSupport() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                            }
                            if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                                if (networkInterfaceCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                                }
                                if (networkInterfaceCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                                }
                            }
                            if (instanceRequirements.getLocalStorage() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                            }
                            if (!(instanceRequirementsRequestLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsRequestLocalStorageTypesList.isAutoConstruct()) {
                                int localStorageTypesListIndex = 1;
                                for (String instanceRequirementsRequestLocalStorageTypesListValue : instanceRequirementsRequestLocalStorageTypesList) {
                                    if (instanceRequirementsRequestLocalStorageTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorageType." + localStorageTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestLocalStorageTypesListValue));
                                    }
                                    ++localStorageTypesListIndex;
                                }
                            }
                            if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                                if (totalLocalStorageGB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)totalLocalStorageGB.getMin()));
                                }
                                if (totalLocalStorageGB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)totalLocalStorageGB.getMax()));
                                }
                            }
                            if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                                if (baselineEbsBandwidthMbps.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                                }
                                if (baselineEbsBandwidthMbps.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsRequestAcceleratorTypesList.isAutoConstruct()) {
                                int acceleratorTypesListIndex = 1;
                                for (String instanceRequirementsRequestAcceleratorTypesListValue : instanceRequirementsRequestAcceleratorTypesList) {
                                    if (instanceRequirementsRequestAcceleratorTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorType." + acceleratorTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorTypesListValue));
                                    }
                                    ++acceleratorTypesListIndex;
                                }
                            }
                            if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                                if (acceleratorCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)acceleratorCount.getMin()));
                                }
                                if (acceleratorCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)acceleratorCount.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsRequestAcceleratorManufacturersList.isAutoConstruct()) {
                                int acceleratorManufacturersListIndex = 1;
                                for (Object instanceRequirementsRequestAcceleratorManufacturersListValue : instanceRequirementsRequestAcceleratorManufacturersList) {
                                    if (instanceRequirementsRequestAcceleratorManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorManufacturer." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorManufacturersListValue));
                                    }
                                    ++acceleratorManufacturersListIndex;
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsRequestAcceleratorNamesList.isAutoConstruct()) {
                                Object instanceRequirementsRequestAcceleratorManufacturersListValue;
                                int acceleratorNamesListIndex = 1;
                                instanceRequirementsRequestAcceleratorManufacturersListValue = instanceRequirementsRequestAcceleratorNamesList.iterator();
                                while (instanceRequirementsRequestAcceleratorManufacturersListValue.hasNext()) {
                                    String instanceRequirementsRequestAcceleratorNamesListValue = (String)instanceRequirementsRequestAcceleratorManufacturersListValue.next();
                                    if (instanceRequirementsRequestAcceleratorNamesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorName." + acceleratorNamesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorNamesListValue));
                                    }
                                    ++acceleratorNamesListIndex;
                                }
                            }
                            if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                                if (acceleratorTotalMemoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                                }
                                if (acceleratorTotalMemoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                                }
                            }
                            if ((networkBandwidthGbps = instanceRequirements.getNetworkBandwidthGbps()) != null) {
                                if (networkBandwidthGbps.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkBandwidthGbps.Min", StringUtils.fromDouble((Double)networkBandwidthGbps.getMin()));
                                }
                                if (networkBandwidthGbps.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkBandwidthGbps.Max", StringUtils.fromDouble((Double)networkBandwidthGbps.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAllowedInstanceTypesList = (SdkInternalList)instanceRequirements.getAllowedInstanceTypes()).isEmpty() || !instanceRequirementsRequestAllowedInstanceTypesList.isAutoConstruct()) {
                                int allowedInstanceTypesListIndex = 1;
                                for (String instanceRequirementsRequestAllowedInstanceTypesListValue : instanceRequirementsRequestAllowedInstanceTypesList) {
                                    if (instanceRequirementsRequestAllowedInstanceTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AllowedInstanceType." + allowedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAllowedInstanceTypesListValue));
                                    }
                                    ++allowedInstanceTypesListIndex;
                                }
                            }
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getImageId() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".ImageId", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getImageId()));
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if ((targetCapacitySpecification = createFleetRequest.getTargetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.getTotalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getTotalTargetCapacity()));
            }
            if (targetCapacitySpecification.getOnDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getOnDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.getSpotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getSpotTargetCapacity()));
            }
            if (targetCapacitySpecification.getDefaultTargetCapacityType() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringUtils.fromString((String)targetCapacitySpecification.getDefaultTargetCapacityType()));
            }
            if (targetCapacitySpecification.getTargetCapacityUnitType() != null) {
                request.addParameter("TargetCapacitySpecification.TargetCapacityUnitType", StringUtils.fromString((String)targetCapacitySpecification.getTargetCapacityUnitType()));
            }
        }
        if (createFleetRequest.getTerminateInstancesWithExpiration() != null) {
            request.addParameter("TerminateInstancesWithExpiration", StringUtils.fromBoolean((Boolean)createFleetRequest.getTerminateInstancesWithExpiration()));
        }
        if (createFleetRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createFleetRequest.getType()));
        }
        if (createFleetRequest.getValidFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate((Date)createFleetRequest.getValidFrom()));
        }
        if (createFleetRequest.getValidUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate((Date)createFleetRequest.getValidUntil()));
        }
        if (createFleetRequest.getReplaceUnhealthyInstances() != null) {
            request.addParameter("ReplaceUnhealthyInstances", StringUtils.fromBoolean((Boolean)createFleetRequest.getReplaceUnhealthyInstances()));
        }
        if (!(createFleetRequestTagSpecificationsList = (SdkInternalList)createFleetRequest.getTagSpecifications()).isEmpty() || !createFleetRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFleetRequestTagSpecificationsListValue : createFleetRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createFleetRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createFleetRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createFleetRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createFleetRequest.getContext() != null) {
            request.addParameter("Context", StringUtils.fromString((String)createFleetRequest.getContext()));
        }
        return request;
    }
}

