/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeHostReservationsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeHostReservationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeHostReservationsRequest> {
    private SdkInternalList<Filter> filter;
    private SdkInternalList<String> hostReservationIdSet;
    private Integer maxResults;
    private String nextToken;

    public List<Filter> getFilter() {
        if (this.filter == null) {
            this.filter = new SdkInternalList();
        }
        return this.filter;
    }

    public void setFilter(Collection<Filter> filter) {
        if (filter == null) {
            this.filter = null;
            return;
        }
        this.filter = new SdkInternalList(filter);
    }

    public DescribeHostReservationsRequest withFilter(Filter ... filter) {
        if (this.filter == null) {
            this.setFilter((Collection<Filter>)new SdkInternalList(filter.length));
        }
        for (Filter ele : filter) {
            this.filter.add((Object)ele);
        }
        return this;
    }

    public DescribeHostReservationsRequest withFilter(Collection<Filter> filter) {
        this.setFilter(filter);
        return this;
    }

    public List<String> getHostReservationIdSet() {
        if (this.hostReservationIdSet == null) {
            this.hostReservationIdSet = new SdkInternalList();
        }
        return this.hostReservationIdSet;
    }

    public void setHostReservationIdSet(Collection<String> hostReservationIdSet) {
        if (hostReservationIdSet == null) {
            this.hostReservationIdSet = null;
            return;
        }
        this.hostReservationIdSet = new SdkInternalList(hostReservationIdSet);
    }

    public DescribeHostReservationsRequest withHostReservationIdSet(String ... hostReservationIdSet) {
        if (this.hostReservationIdSet == null) {
            this.setHostReservationIdSet((Collection<String>)new SdkInternalList(hostReservationIdSet.length));
        }
        for (String ele : hostReservationIdSet) {
            this.hostReservationIdSet.add((Object)ele);
        }
        return this;
    }

    public DescribeHostReservationsRequest withHostReservationIdSet(Collection<String> hostReservationIdSet) {
        this.setHostReservationIdSet(hostReservationIdSet);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeHostReservationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeHostReservationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    @Override
    public Request<DescribeHostReservationsRequest> getDryRunRequest() {
        Request<DescribeHostReservationsRequest> request = new DescribeHostReservationsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getHostReservationIdSet() != null) {
            sb.append("HostReservationIdSet: ").append(this.getHostReservationIdSet()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsRequest)) {
            return false;
        }
        DescribeHostReservationsRequest other = (DescribeHostReservationsRequest)obj;
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getHostReservationIdSet() == null ^ this.getHostReservationIdSet() == null) {
            return false;
        }
        if (other.getHostReservationIdSet() != null && !other.getHostReservationIdSet().equals(this.getHostReservationIdSet())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getHostReservationIdSet() == null ? 0 : this.getHostReservationIdSet().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeHostReservationsRequest clone() {
        return (DescribeHostReservationsRequest)super.clone();
    }
}

