/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessTrustProviderRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessTrustProviderRequest>, ModifyVerifiedAccessTrustProviderRequest> {
    public Request<ModifyVerifiedAccessTrustProviderRequest> marshall(ModifyVerifiedAccessTrustProviderRequest modifyVerifiedAccessTrustProviderRequest) {
        ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;
        if (modifyVerifiedAccessTrustProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVerifiedAccessTrustProviderRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessTrustProvider");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessTrustProviderRequest.getVerifiedAccessTrustProviderId() != null) {
            request.addParameter("VerifiedAccessTrustProviderId", StringUtils.fromString((String)modifyVerifiedAccessTrustProviderRequest.getVerifiedAccessTrustProviderId()));
        }
        if ((oidcOptions = modifyVerifiedAccessTrustProviderRequest.getOidcOptions()) != null && oidcOptions.getScope() != null) {
            request.addParameter("OidcOptions.Scope", StringUtils.fromString((String)oidcOptions.getScope()));
        }
        if (modifyVerifiedAccessTrustProviderRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyVerifiedAccessTrustProviderRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)modifyVerifiedAccessTrustProviderRequest.getClientToken()));
        return request;
    }
}

