/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVpnGatewayRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpnGatewayRequestMarshaller
implements Marshaller<Request<CreateVpnGatewayRequest>, CreateVpnGatewayRequest> {
    public Request<CreateVpnGatewayRequest> marshall(CreateVpnGatewayRequest createVpnGatewayRequest) {
        SdkInternalList createVpnGatewayRequestTagSpecificationsList;
        if (createVpnGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpnGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpnGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnGatewayRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createVpnGatewayRequest.getAvailabilityZone()));
        }
        if (createVpnGatewayRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createVpnGatewayRequest.getType()));
        }
        if (!(createVpnGatewayRequestTagSpecificationsList = (SdkInternalList)createVpnGatewayRequest.getTagSpecifications()).isEmpty() || !createVpnGatewayRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVpnGatewayRequestTagSpecificationsListValue : createVpnGatewayRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVpnGatewayRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVpnGatewayRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVpnGatewayRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createVpnGatewayRequest.getAmazonSideAsn() != null) {
            request.addParameter("AmazonSideAsn", StringUtils.fromLong((Long)createVpnGatewayRequest.getAmazonSideAsn()));
        }
        return request;
    }
}

