/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.MemoryInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MemoryInfoStaxUnmarshaller
implements Unmarshaller<MemoryInfo, StaxUnmarshallerContext> {
    private static MemoryInfoStaxUnmarshaller instance;

    public MemoryInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        MemoryInfo memoryInfo = new MemoryInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return memoryInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("sizeInMiB", targetDepth)) continue;
                memoryInfo.setSizeInMiB(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return memoryInfo;
    }

    public static MemoryInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MemoryInfoStaxUnmarshaller();
        }
        return instance;
    }
}

