/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeStoreImageTasksRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeStoreImageTasksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeStoreImageTasksRequest> {
    private SdkInternalList<String> imageIds;
    private SdkInternalList<Filter> filters;
    private String nextToken;
    private Integer maxResults;

    public List<String> getImageIds() {
        if (this.imageIds == null) {
            this.imageIds = new SdkInternalList();
        }
        return this.imageIds;
    }

    public void setImageIds(Collection<String> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
            return;
        }
        this.imageIds = new SdkInternalList(imageIds);
    }

    public DescribeStoreImageTasksRequest withImageIds(String ... imageIds) {
        if (this.imageIds == null) {
            this.setImageIds((Collection<String>)new SdkInternalList(imageIds.length));
        }
        for (String ele : imageIds) {
            this.imageIds.add((Object)ele);
        }
        return this;
    }

    public DescribeStoreImageTasksRequest withImageIds(Collection<String> imageIds) {
        this.setImageIds(imageIds);
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public DescribeStoreImageTasksRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<Filter>)new SdkInternalList(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public DescribeStoreImageTasksRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeStoreImageTasksRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeStoreImageTasksRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    @Override
    public Request<DescribeStoreImageTasksRequest> getDryRunRequest() {
        Request<DescribeStoreImageTasksRequest> request = new DescribeStoreImageTasksRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageIds() != null) {
            sb.append("ImageIds: ").append(this.getImageIds()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStoreImageTasksRequest)) {
            return false;
        }
        DescribeStoreImageTasksRequest other = (DescribeStoreImageTasksRequest)obj;
        if (other.getImageIds() == null ^ this.getImageIds() == null) {
            return false;
        }
        if (other.getImageIds() != null && !other.getImageIds().equals(this.getImageIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageIds() == null ? 0 : this.getImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public DescribeStoreImageTasksRequest clone() {
        return (DescribeStoreImageTasksRequest)super.clone();
    }
}

