/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReplaceIamInstanceProfileAssociationRequestMarshaller
implements Marshaller<Request<ReplaceIamInstanceProfileAssociationRequest>, ReplaceIamInstanceProfileAssociationRequest> {
    public Request<ReplaceIamInstanceProfileAssociationRequest> marshall(ReplaceIamInstanceProfileAssociationRequest replaceIamInstanceProfileAssociationRequest) {
        if (replaceIamInstanceProfileAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceIamInstanceProfileAssociationRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceIamInstanceProfileAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        IamInstanceProfileSpecification iamInstanceProfile = replaceIamInstanceProfileAssociationRequest.getIamInstanceProfile();
        if (iamInstanceProfile != null) {
            if (iamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
            }
            if (iamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
            }
        }
        if (replaceIamInstanceProfileAssociationRequest.getAssociationId() != null) {
            request.addParameter("AssociationId", StringUtils.fromString((String)replaceIamInstanceProfileAssociationRequest.getAssociationId()));
        }
        return request;
    }
}

