/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImportSnapshotRequest;
import com.amazonaws.services.ec2.model.SnapshotDiskContainer;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class ImportSnapshotRequestMarshaller
implements Marshaller<Request<ImportSnapshotRequest>, ImportSnapshotRequest> {
    public Request<ImportSnapshotRequest> marshall(ImportSnapshotRequest importSnapshotRequest) {
        SdkInternalList importSnapshotRequestTagSpecificationsList;
        SnapshotDiskContainer diskContainer;
        if (importSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importSnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "ImportSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        ClientData clientData = importSnapshotRequest.getClientData();
        if (clientData != null) {
            if (clientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString((String)clientData.getComment()));
            }
            if (clientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate((Date)clientData.getUploadEnd()));
            }
            if (clientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble((Double)clientData.getUploadSize()));
            }
            if (clientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate((Date)clientData.getUploadStart()));
            }
        }
        if (importSnapshotRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)importSnapshotRequest.getClientToken()));
        }
        if (importSnapshotRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importSnapshotRequest.getDescription()));
        }
        if ((diskContainer = importSnapshotRequest.getDiskContainer()) != null) {
            UserBucket userBucket;
            if (diskContainer.getDescription() != null) {
                request.addParameter("DiskContainer.Description", StringUtils.fromString((String)diskContainer.getDescription()));
            }
            if (diskContainer.getFormat() != null) {
                request.addParameter("DiskContainer.Format", StringUtils.fromString((String)diskContainer.getFormat()));
            }
            if (diskContainer.getUrl() != null) {
                request.addParameter("DiskContainer.Url", StringUtils.fromString((String)diskContainer.getUrl()));
            }
            if ((userBucket = diskContainer.getUserBucket()) != null) {
                if (userBucket.getS3Bucket() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Bucket", StringUtils.fromString((String)userBucket.getS3Bucket()));
                }
                if (userBucket.getS3Key() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Key", StringUtils.fromString((String)userBucket.getS3Key()));
                }
            }
        }
        if (importSnapshotRequest.getEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)importSnapshotRequest.getEncrypted()));
        }
        if (importSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)importSnapshotRequest.getKmsKeyId()));
        }
        if (importSnapshotRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)importSnapshotRequest.getRoleName()));
        }
        if (!(importSnapshotRequestTagSpecificationsList = (SdkInternalList)importSnapshotRequest.getTagSpecifications()).isEmpty() || !importSnapshotRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification importSnapshotRequestTagSpecificationsListValue : importSnapshotRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (importSnapshotRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)importSnapshotRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)importSnapshotRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

