/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AssociateIamInstanceProfileRequest;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssociateIamInstanceProfileRequestMarshaller
implements Marshaller<Request<AssociateIamInstanceProfileRequest>, AssociateIamInstanceProfileRequest> {
    public Request<AssociateIamInstanceProfileRequest> marshall(AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) {
        if (associateIamInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateIamInstanceProfileRequest, "AmazonEC2");
        request.addParameter("Action", "AssociateIamInstanceProfile");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        IamInstanceProfileSpecification iamInstanceProfile = associateIamInstanceProfileRequest.getIamInstanceProfile();
        if (iamInstanceProfile != null) {
            if (iamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
            }
            if (iamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
            }
        }
        if (associateIamInstanceProfileRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)associateIamInstanceProfileRequest.getInstanceId()));
        }
        return request;
    }
}

