/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateImageRequestMarshaller
implements Marshaller<Request<CreateImageRequest>, CreateImageRequest> {
    public Request<CreateImageRequest> marshall(CreateImageRequest createImageRequest) {
        if (createImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createImageRequest, "AmazonEC2");
        request.addParameter("Action", "CreateImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createImageRequestBlockDeviceMappingsList = (SdkInternalList)createImageRequest.getBlockDeviceMappings();
        if (!createImageRequestBlockDeviceMappingsList.isEmpty() || !createImageRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping createImageRequestBlockDeviceMappingsListValue : createImageRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (createImageRequestBlockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)createImageRequestBlockDeviceMappingsListValue.getDeviceName()));
                }
                if (createImageRequestBlockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)createImageRequestBlockDeviceMappingsListValue.getVirtualName()));
                }
                if ((ebs = createImageRequestBlockDeviceMappingsListValue.getEbs()) != null) {
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                    }
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                    }
                    if (ebs.getKmsKeyId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString((String)ebs.getKmsKeyId()));
                    }
                    if (ebs.getThroughput() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger((Integer)ebs.getThroughput()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                    }
                }
                if (createImageRequestBlockDeviceMappingsListValue.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)createImageRequestBlockDeviceMappingsListValue.getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (createImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createImageRequest.getDescription()));
        }
        if (createImageRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createImageRequest.getInstanceId()));
        }
        if (createImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createImageRequest.getName()));
        }
        if (createImageRequest.getNoReboot() != null) {
            request.addParameter("NoReboot", StringUtils.fromBoolean((Boolean)createImageRequest.getNoReboot()));
        }
        return request;
    }
}

