/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateTrafficMirrorSessionRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateTrafficMirrorSessionRequestMarshaller
implements Marshaller<Request<CreateTrafficMirrorSessionRequest>, CreateTrafficMirrorSessionRequest> {
    public Request<CreateTrafficMirrorSessionRequest> marshall(CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest) {
        SdkInternalList createTrafficMirrorSessionRequestTagSpecificationsList;
        if (createTrafficMirrorSessionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTrafficMirrorSessionRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTrafficMirrorSession");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTrafficMirrorSessionRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)createTrafficMirrorSessionRequest.getNetworkInterfaceId()));
        }
        if (createTrafficMirrorSessionRequest.getTrafficMirrorTargetId() != null) {
            request.addParameter("TrafficMirrorTargetId", StringUtils.fromString((String)createTrafficMirrorSessionRequest.getTrafficMirrorTargetId()));
        }
        if (createTrafficMirrorSessionRequest.getTrafficMirrorFilterId() != null) {
            request.addParameter("TrafficMirrorFilterId", StringUtils.fromString((String)createTrafficMirrorSessionRequest.getTrafficMirrorFilterId()));
        }
        if (createTrafficMirrorSessionRequest.getPacketLength() != null) {
            request.addParameter("PacketLength", StringUtils.fromInteger((Integer)createTrafficMirrorSessionRequest.getPacketLength()));
        }
        if (createTrafficMirrorSessionRequest.getSessionNumber() != null) {
            request.addParameter("SessionNumber", StringUtils.fromInteger((Integer)createTrafficMirrorSessionRequest.getSessionNumber()));
        }
        if (createTrafficMirrorSessionRequest.getVirtualNetworkId() != null) {
            request.addParameter("VirtualNetworkId", StringUtils.fromInteger((Integer)createTrafficMirrorSessionRequest.getVirtualNetworkId()));
        }
        if (createTrafficMirrorSessionRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createTrafficMirrorSessionRequest.getDescription()));
        }
        if (!(createTrafficMirrorSessionRequestTagSpecificationsList = (SdkInternalList)createTrafficMirrorSessionRequest.getTagSpecifications()).isEmpty() || !createTrafficMirrorSessionRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createTrafficMirrorSessionRequestTagSpecificationsListValue : createTrafficMirrorSessionRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createTrafficMirrorSessionRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createTrafficMirrorSessionRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createTrafficMirrorSessionRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createTrafficMirrorSessionRequest.getClientToken()));
        return request;
    }
}

