/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeFastSnapshotRestoresRequestMarshaller
implements Marshaller<Request<DescribeFastSnapshotRestoresRequest>, DescribeFastSnapshotRestoresRequest> {
    public Request<DescribeFastSnapshotRestoresRequest> marshall(DescribeFastSnapshotRestoresRequest describeFastSnapshotRestoresRequest) {
        if (describeFastSnapshotRestoresRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFastSnapshotRestoresRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFastSnapshotRestores");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeFastSnapshotRestoresRequestFiltersList = (SdkInternalList)describeFastSnapshotRestoresRequest.getFilters();
        if (!describeFastSnapshotRestoresRequestFiltersList.isEmpty() || !describeFastSnapshotRestoresRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeFastSnapshotRestoresRequestFiltersListValue : describeFastSnapshotRestoresRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeFastSnapshotRestoresRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeFastSnapshotRestoresRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeFastSnapshotRestoresRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeFastSnapshotRestoresRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFastSnapshotRestoresRequest.getMaxResults()));
        }
        if (describeFastSnapshotRestoresRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFastSnapshotRestoresRequest.getNextToken()));
        }
        return request;
    }
}

