/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest;
import com.amazonaws.services.ec2.model.PriceScheduleSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateReservedInstancesListingRequestMarshaller
implements Marshaller<Request<CreateReservedInstancesListingRequest>, CreateReservedInstancesListingRequest> {
    public Request<CreateReservedInstancesListingRequest> marshall(CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        SdkInternalList createReservedInstancesListingRequestPriceSchedulesList;
        if (createReservedInstancesListingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReservedInstancesListingRequest, "AmazonEC2");
        request.addParameter("Action", "CreateReservedInstancesListing");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReservedInstancesListingRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createReservedInstancesListingRequest.getClientToken()));
        }
        if (createReservedInstancesListingRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)createReservedInstancesListingRequest.getInstanceCount()));
        }
        if (!(createReservedInstancesListingRequestPriceSchedulesList = (SdkInternalList)createReservedInstancesListingRequest.getPriceSchedules()).isEmpty() || !createReservedInstancesListingRequestPriceSchedulesList.isAutoConstruct()) {
            int priceSchedulesListIndex = 1;
            for (PriceScheduleSpecification createReservedInstancesListingRequestPriceSchedulesListValue : createReservedInstancesListingRequestPriceSchedulesList) {
                if (createReservedInstancesListingRequestPriceSchedulesListValue.getCurrencyCode() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".CurrencyCode", StringUtils.fromString((String)createReservedInstancesListingRequestPriceSchedulesListValue.getCurrencyCode()));
                }
                if (createReservedInstancesListingRequestPriceSchedulesListValue.getPrice() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Price", StringUtils.fromDouble((Double)createReservedInstancesListingRequestPriceSchedulesListValue.getPrice()));
                }
                if (createReservedInstancesListingRequestPriceSchedulesListValue.getTerm() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Term", StringUtils.fromLong((Long)createReservedInstancesListingRequestPriceSchedulesListValue.getTerm()));
                }
                ++priceSchedulesListIndex;
            }
        }
        if (createReservedInstancesListingRequest.getReservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString((String)createReservedInstancesListingRequest.getReservedInstancesId()));
        }
        return request;
    }
}

