/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        SdkInternalList describeImagesRequestFiltersList;
        SdkInternalList describeImagesRequestExecutableUsersList;
        SdkInternalList describeImagesRequestOwnersList;
        if (describeImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImagesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeImagesRequestImageIdsList = (SdkInternalList)describeImagesRequest.getImageIds();
        if (!describeImagesRequestImageIdsList.isEmpty() || !describeImagesRequestImageIdsList.isAutoConstruct()) {
            int imageIdsListIndex = 1;
            for (Object describeImagesRequestImageIdsListValue : describeImagesRequestImageIdsList) {
                if (describeImagesRequestImageIdsListValue != null) {
                    request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString((String)describeImagesRequestImageIdsListValue));
                }
                ++imageIdsListIndex;
            }
        }
        if (!(describeImagesRequestOwnersList = (SdkInternalList)describeImagesRequest.getOwners()).isEmpty() || !describeImagesRequestOwnersList.isAutoConstruct()) {
            int ownersListIndex = 1;
            for (Object describeImagesRequestOwnersListValue : describeImagesRequestOwnersList) {
                if (describeImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringUtils.fromString((String)describeImagesRequestOwnersListValue));
                }
                ++ownersListIndex;
            }
        }
        if (!(describeImagesRequestExecutableUsersList = (SdkInternalList)describeImagesRequest.getExecutableUsers()).isEmpty() || !describeImagesRequestExecutableUsersList.isAutoConstruct()) {
            int executableUsersListIndex = 1;
            for (String describeImagesRequestExecutableUsersListValue : describeImagesRequestExecutableUsersList) {
                if (describeImagesRequestExecutableUsersListValue != null) {
                    request.addParameter("ExecutableBy." + executableUsersListIndex, StringUtils.fromString((String)describeImagesRequestExecutableUsersListValue));
                }
                ++executableUsersListIndex;
            }
        }
        if (!(describeImagesRequestFiltersList = (SdkInternalList)describeImagesRequest.getFilters()).isEmpty() || !describeImagesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeImagesRequestFiltersListValue : describeImagesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeImagesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeImagesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeImagesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

