/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeImportSnapshotTasksRequestMarshaller
implements Marshaller<Request<DescribeImportSnapshotTasksRequest>, DescribeImportSnapshotTasksRequest> {
    public Request<DescribeImportSnapshotTasksRequest> marshall(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        SdkInternalList describeImportSnapshotTasksRequestFiltersList;
        if (describeImportSnapshotTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImportSnapshotTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeImportSnapshotTasks");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeImportSnapshotTasksRequestImportTaskIdsList = (SdkInternalList)describeImportSnapshotTasksRequest.getImportTaskIds();
        if (!describeImportSnapshotTasksRequestImportTaskIdsList.isEmpty() || !describeImportSnapshotTasksRequestImportTaskIdsList.isAutoConstruct()) {
            int importTaskIdsListIndex = 1;
            for (String describeImportSnapshotTasksRequestImportTaskIdsListValue : describeImportSnapshotTasksRequestImportTaskIdsList) {
                if (describeImportSnapshotTasksRequestImportTaskIdsListValue != null) {
                    request.addParameter("ImportTaskId." + importTaskIdsListIndex, StringUtils.fromString((String)describeImportSnapshotTasksRequestImportTaskIdsListValue));
                }
                ++importTaskIdsListIndex;
            }
        }
        if (describeImportSnapshotTasksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeImportSnapshotTasksRequest.getNextToken()));
        }
        if (describeImportSnapshotTasksRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeImportSnapshotTasksRequest.getMaxResults()));
        }
        if (!(describeImportSnapshotTasksRequestFiltersList = (SdkInternalList)describeImportSnapshotTasksRequest.getFilters()).isEmpty() || !describeImportSnapshotTasksRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeImportSnapshotTasksRequestFiltersListValue : describeImportSnapshotTasksRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeImportSnapshotTasksRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filters." + filtersListIndex + ".Name", StringUtils.fromString((String)describeImportSnapshotTasksRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeImportSnapshotTasksRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filters." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

