/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateFlowLogsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateFlowLogsRequestMarshaller
implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {
    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {
        if (createFlowLogsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createFlowLogsRequestResourceIdsList = (SdkInternalList)createFlowLogsRequest.getResourceIds();
        if (!createFlowLogsRequestResourceIdsList.isEmpty() || !createFlowLogsRequestResourceIdsList.isAutoConstruct()) {
            int resourceIdsListIndex = 1;
            for (String createFlowLogsRequestResourceIdsListValue : createFlowLogsRequestResourceIdsList) {
                if (createFlowLogsRequestResourceIdsListValue != null) {
                    request.addParameter("ResourceId." + resourceIdsListIndex, StringUtils.fromString((String)createFlowLogsRequestResourceIdsListValue));
                }
                ++resourceIdsListIndex;
            }
        }
        if (createFlowLogsRequest.getResourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString((String)createFlowLogsRequest.getResourceType()));
        }
        if (createFlowLogsRequest.getTrafficType() != null) {
            request.addParameter("TrafficType", StringUtils.fromString((String)createFlowLogsRequest.getTrafficType()));
        }
        if (createFlowLogsRequest.getLogGroupName() != null) {
            request.addParameter("LogGroupName", StringUtils.fromString((String)createFlowLogsRequest.getLogGroupName()));
        }
        if (createFlowLogsRequest.getDeliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn", StringUtils.fromString((String)createFlowLogsRequest.getDeliverLogsPermissionArn()));
        }
        if (createFlowLogsRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createFlowLogsRequest.getClientToken()));
        }
        return request;
    }
}

