/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        SdkInternalList removeRouteTableIdsList;
        SdkInternalList addRouteTableIdsList;
        if (modifyVpcEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcEndpointRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString((String)modifyVpcEndpointRequest.getVpcEndpointId()));
        }
        if (modifyVpcEndpointRequest.getResetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean((Boolean)modifyVpcEndpointRequest.getResetPolicy()));
        }
        if (modifyVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)modifyVpcEndpointRequest.getPolicyDocument()));
        }
        if (!(addRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddRouteTableIds()).isEmpty() || !addRouteTableIdsList.isAutoConstruct()) {
            int addRouteTableIdsListIndex = 1;
            for (String addRouteTableIdsListValue : addRouteTableIdsList) {
                if (addRouteTableIdsListValue != null) {
                    request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString((String)addRouteTableIdsListValue));
                }
                ++addRouteTableIdsListIndex;
            }
        }
        if (!(removeRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveRouteTableIds()).isEmpty() || !removeRouteTableIdsList.isAutoConstruct()) {
            int removeRouteTableIdsListIndex = 1;
            for (String removeRouteTableIdsListValue : removeRouteTableIdsList) {
                if (removeRouteTableIdsListValue != null) {
                    request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString((String)removeRouteTableIdsListValue));
                }
                ++removeRouteTableIdsListIndex;
            }
        }
        return request;
    }
}

