/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeNatGatewaysRequestMarshaller
implements Marshaller<Request<DescribeNatGatewaysRequest>, DescribeNatGatewaysRequest> {
    public Request<DescribeNatGatewaysRequest> marshall(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        SdkInternalList filterList;
        if (describeNatGatewaysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNatGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNatGateways");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList natGatewayIdsList = (SdkInternalList)describeNatGatewaysRequest.getNatGatewayIds();
        if (!natGatewayIdsList.isEmpty() || !natGatewayIdsList.isAutoConstruct()) {
            int natGatewayIdsListIndex = 1;
            for (String natGatewayIdsListValue : natGatewayIdsList) {
                if (natGatewayIdsListValue != null) {
                    request.addParameter("NatGatewayId." + natGatewayIdsListIndex, StringUtils.fromString((String)natGatewayIdsListValue));
                }
                ++natGatewayIdsListIndex;
            }
        }
        if (!(filterList = (SdkInternalList)describeNatGatewaysRequest.getFilter()).isEmpty() || !filterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter filterListValue : filterList) {
                SdkInternalList valuesList;
                if (filterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)filterListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filterListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeNatGatewaysRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeNatGatewaysRequest.getMaxResults()));
        }
        if (describeNatGatewaysRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeNatGatewaysRequest.getNextToken()));
        }
        return request;
    }
}

