/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeKeyPairsRequestMarshaller
implements Marshaller<Request<DescribeKeyPairsRequest>, DescribeKeyPairsRequest> {
    public Request<DescribeKeyPairsRequest> marshall(DescribeKeyPairsRequest describeKeyPairsRequest) {
        SdkInternalList filtersList;
        if (describeKeyPairsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeKeyPairsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeKeyPairs");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList keyNamesList = (SdkInternalList)describeKeyPairsRequest.getKeyNames();
        if (!keyNamesList.isEmpty() || !keyNamesList.isAutoConstruct()) {
            int keyNamesListIndex = 1;
            for (String keyNamesListValue : keyNamesList) {
                if (keyNamesListValue != null) {
                    request.addParameter("KeyName." + keyNamesListIndex, StringUtils.fromString((String)keyNamesListValue));
                }
                ++keyNamesListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeKeyPairsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

