/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeExportTasksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeExportTasksRequestMarshaller
implements Marshaller<Request<DescribeExportTasksRequest>, DescribeExportTasksRequest> {
    public Request<DescribeExportTasksRequest> marshall(DescribeExportTasksRequest describeExportTasksRequest) {
        if (describeExportTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExportTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeExportTasks");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList exportTaskIdsList = (SdkInternalList)describeExportTasksRequest.getExportTaskIds();
        if (!exportTaskIdsList.isEmpty() || !exportTaskIdsList.isAutoConstruct()) {
            int exportTaskIdsListIndex = 1;
            for (String exportTaskIdsListValue : exportTaskIdsList) {
                if (exportTaskIdsListValue != null) {
                    request.addParameter("ExportTaskId." + exportTaskIdsListIndex, StringUtils.fromString((String)exportTaskIdsListValue));
                }
                ++exportTaskIdsListIndex;
            }
        }
        return request;
    }
}

