/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVpcEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpcEndpointRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointRequest>, CreateVpcEndpointRequest> {
    public Request<CreateVpcEndpointRequest> marshall(CreateVpcEndpointRequest createVpcEndpointRequest) {
        SdkInternalList routeTableIdsList;
        if (createVpcEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpcEndpoint");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createVpcEndpointRequest.getVpcId()));
        }
        if (createVpcEndpointRequest.getServiceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString((String)createVpcEndpointRequest.getServiceName()));
        }
        if (createVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createVpcEndpointRequest.getPolicyDocument()));
        }
        if (!(routeTableIdsList = (SdkInternalList)createVpcEndpointRequest.getRouteTableIds()).isEmpty() || !routeTableIdsList.isAutoConstruct()) {
            int routeTableIdsListIndex = 1;
            for (String routeTableIdsListValue : routeTableIdsList) {
                if (routeTableIdsListValue != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString((String)routeTableIdsListValue));
                }
                ++routeTableIdsListIndex;
            }
        }
        if (createVpcEndpointRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createVpcEndpointRequest.getClientToken()));
        }
        return request;
    }
}

