/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeReservedInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesOfferingsRequest>, DescribeReservedInstancesOfferingsRequest> {
    public Request<DescribeReservedInstancesOfferingsRequest> marshall(DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        SdkInternalList filtersList;
        if (describeReservedInstancesOfferingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesOfferingsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeReservedInstancesOfferings");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList reservedInstancesOfferingIdsList = (SdkInternalList)describeReservedInstancesOfferingsRequest.getReservedInstancesOfferingIds();
        if (!reservedInstancesOfferingIdsList.isEmpty() || !reservedInstancesOfferingIdsList.isAutoConstruct()) {
            int reservedInstancesOfferingIdsListIndex = 1;
            for (String reservedInstancesOfferingIdsListValue : reservedInstancesOfferingIdsList) {
                if (reservedInstancesOfferingIdsListValue != null) {
                    request.addParameter("ReservedInstancesOfferingId." + reservedInstancesOfferingIdsListIndex, StringUtils.fromString((String)reservedInstancesOfferingIdsListValue));
                }
                ++reservedInstancesOfferingIdsListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getInstanceType()));
        }
        if (describeReservedInstancesOfferingsRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getAvailabilityZone()));
        }
        if (describeReservedInstancesOfferingsRequest.getProductDescription() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getProductDescription()));
        }
        if (!(filtersList = (SdkInternalList)describeReservedInstancesOfferingsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.getInstanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getInstanceTenancy()));
        }
        if (describeReservedInstancesOfferingsRequest.getOfferingType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getOfferingType()));
        }
        if (describeReservedInstancesOfferingsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getNextToken()));
        }
        if (describeReservedInstancesOfferingsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.getMaxResults()));
        }
        if (describeReservedInstancesOfferingsRequest.getIncludeMarketplace() != null) {
            request.addParameter("IncludeMarketplace", StringUtils.fromBoolean((Boolean)describeReservedInstancesOfferingsRequest.getIncludeMarketplace()));
        }
        if (describeReservedInstancesOfferingsRequest.getMinDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.getMinDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.getMaxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.getMaxDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.getMaxInstanceCount() != null) {
            request.addParameter("MaxInstanceCount", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.getMaxInstanceCount()));
        }
        return request;
    }
}

