/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.waiters.BundleTaskComplete;
import com.amazonaws.services.ec2.waiters.ConversionTaskCancelled;
import com.amazonaws.services.ec2.waiters.ConversionTaskCompleted;
import com.amazonaws.services.ec2.waiters.ConversionTaskDeleted;
import com.amazonaws.services.ec2.waiters.CustomerGatewayAvailable;
import com.amazonaws.services.ec2.waiters.DescribeBundleTasksFunction;
import com.amazonaws.services.ec2.waiters.DescribeConversionTasksFunction;
import com.amazonaws.services.ec2.waiters.DescribeCustomerGatewaysFunction;
import com.amazonaws.services.ec2.waiters.DescribeExportTasksFunction;
import com.amazonaws.services.ec2.waiters.DescribeImagesFunction;
import com.amazonaws.services.ec2.waiters.DescribeInstanceStatusFunction;
import com.amazonaws.services.ec2.waiters.DescribeInstancesFunction;
import com.amazonaws.services.ec2.waiters.DescribeKeyPairsFunction;
import com.amazonaws.services.ec2.waiters.DescribeNatGatewaysFunction;
import com.amazonaws.services.ec2.waiters.DescribeNetworkInterfacesFunction;
import com.amazonaws.services.ec2.waiters.DescribeSnapshotsFunction;
import com.amazonaws.services.ec2.waiters.DescribeSpotInstanceRequestsFunction;
import com.amazonaws.services.ec2.waiters.DescribeSubnetsFunction;
import com.amazonaws.services.ec2.waiters.DescribeVolumesFunction;
import com.amazonaws.services.ec2.waiters.DescribeVpcPeeringConnectionsFunction;
import com.amazonaws.services.ec2.waiters.DescribeVpcsFunction;
import com.amazonaws.services.ec2.waiters.DescribeVpnConnectionsFunction;
import com.amazonaws.services.ec2.waiters.ExportTaskCancelled;
import com.amazonaws.services.ec2.waiters.ExportTaskCompleted;
import com.amazonaws.services.ec2.waiters.GetPasswordDataFunction;
import com.amazonaws.services.ec2.waiters.ImageAvailable;
import com.amazonaws.services.ec2.waiters.ImageExists;
import com.amazonaws.services.ec2.waiters.InstanceExists;
import com.amazonaws.services.ec2.waiters.InstanceRunning;
import com.amazonaws.services.ec2.waiters.InstanceStatusOk;
import com.amazonaws.services.ec2.waiters.InstanceStopped;
import com.amazonaws.services.ec2.waiters.InstanceTerminated;
import com.amazonaws.services.ec2.waiters.KeyPairExists;
import com.amazonaws.services.ec2.waiters.NatGatewayAvailable;
import com.amazonaws.services.ec2.waiters.NetworkInterfaceAvailable;
import com.amazonaws.services.ec2.waiters.PasswordDataAvailable;
import com.amazonaws.services.ec2.waiters.SnapshotCompleted;
import com.amazonaws.services.ec2.waiters.SpotInstanceRequestFulfilled;
import com.amazonaws.services.ec2.waiters.SubnetAvailable;
import com.amazonaws.services.ec2.waiters.SystemStatusOk;
import com.amazonaws.services.ec2.waiters.VolumeAvailable;
import com.amazonaws.services.ec2.waiters.VolumeDeleted;
import com.amazonaws.services.ec2.waiters.VolumeInUse;
import com.amazonaws.services.ec2.waiters.VpcAvailable;
import com.amazonaws.services.ec2.waiters.VpcExists;
import com.amazonaws.services.ec2.waiters.VpcPeeringConnectionExists;
import com.amazonaws.services.ec2.waiters.VpnConnectionAvailable;
import com.amazonaws.services.ec2.waiters.VpnConnectionDeleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonEC2Waiters {
    private final AmazonEC2 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonEC2Waiters(AmazonEC2 client) {
        this.client = client;
    }

    public Waiter passwordDataAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetPasswordDataFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new PasswordDataAvailable.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter volumeInUse() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVolumesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VolumeInUse.IsInuseMatcher(), new VolumeInUse.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter imageAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImagesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageAvailable.IsAvailableMatcher(), new ImageAvailable.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter networkInterfaceAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNetworkInterfacesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NetworkInterfaceAvailable.IsAvailableMatcher(), new NetworkInterfaceAvailable.IsInvalidNetworkInterfaceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(10), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter systemStatusOk() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceStatusFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SystemStatusOk.IsOkMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter vpcPeeringConnectionExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpcPeeringConnectionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new VpcPeeringConnectionExists.IsInvalidVpcPeeringConnectionIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter volumeAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVolumesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VolumeAvailable.IsAvailableMatcher(), new VolumeAvailable.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter instanceStatusOk() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceStatusFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceStatusOk.IsOkMatcher(), new InstanceStatusOk.IsInvalidInstanceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter volumeDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVolumesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VolumeDeleted.IsDeletedMatcher(), new VolumeDeleted.IsInvalidVolumeNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter customerGatewayAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeCustomerGatewaysFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CustomerGatewayAvailable.IsAvailableMatcher(), new CustomerGatewayAvailable.IsDeletedMatcher(), new CustomerGatewayAvailable.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter natGatewayAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNatGatewaysFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NatGatewayAvailable.IsAvailableMatcher(), new NatGatewayAvailable.IsFailedMatcher(), new NatGatewayAvailable.IsDeletingMatcher(), new NatGatewayAvailable.IsDeletedMatcher(), new NatGatewayAvailable.IsNatGatewayNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter vpcExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpcsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new VpcExists.IsInvalidVpcIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(5), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter conversionTaskDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeConversionTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ConversionTaskDeleted.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter imageExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImagesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageExists.IsTrueMatcher(), new ImageExists.IsInvalidAMIIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter vpcAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpcsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VpcAvailable.IsAvailableMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter conversionTaskCancelled() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeConversionTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ConversionTaskCancelled.IsCancelledMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter instanceExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceExists.IsTrueMatcher(), new InstanceExists.IsInvalidInstanceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter instanceTerminated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceTerminated.IsTerminatedMatcher(), new InstanceTerminated.IsPendingMatcher(), new InstanceTerminated.IsStoppingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter conversionTaskCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeConversionTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ConversionTaskCompleted.IsCompletedMatcher(), new ConversionTaskCompleted.IsCancelledMatcher(), new ConversionTaskCompleted.IsCancellingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter keyPairExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeKeyPairsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new KeyPairExists.IsTrueMatcher(), new KeyPairExists.IsInvalidKeyPairNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(6), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter spotInstanceRequestFulfilled() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeSpotInstanceRequestsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SpotInstanceRequestFulfilled.IsFulfilledMatcher(), new SpotInstanceRequestFulfilled.IsScheduleexpiredMatcher(), new SpotInstanceRequestFulfilled.IsCanceledbeforefulfillmentMatcher(), new SpotInstanceRequestFulfilled.IsBadparametersMatcher(), new SpotInstanceRequestFulfilled.IsSystemerrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter bundleTaskComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeBundleTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new BundleTaskComplete.IsCompleteMatcher(), new BundleTaskComplete.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter instanceRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceRunning.IsRunningMatcher(), new InstanceRunning.IsShuttingdownMatcher(), new InstanceRunning.IsTerminatedMatcher(), new InstanceRunning.IsStoppingMatcher(), new InstanceRunning.IsInvalidInstanceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter exportTaskCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeExportTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ExportTaskCompleted.IsCompletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter snapshotCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeSnapshotsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SnapshotCompleted.IsCompletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter exportTaskCancelled() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeExportTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ExportTaskCancelled.IsCancelledMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter vpnConnectionDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpnConnectionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VpnConnectionDeleted.IsDeletedMatcher(), new VpnConnectionDeleted.IsPendingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter vpnConnectionAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpnConnectionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VpnConnectionAvailable.IsAvailableMatcher(), new VpnConnectionAvailable.IsDeletingMatcher(), new VpnConnectionAvailable.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter instanceStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceStopped.IsStoppedMatcher(), new InstanceStopped.IsPendingMatcher(), new InstanceStopped.IsTerminatedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter subnetAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeSubnetsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SubnetAvailable.IsAvailableMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

