/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.transform.DescribeClientVpnEndpointsRequestMarshaller;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeClientVpnEndpointsRequest extends AmazonWebServiceRequest implements Serializable, Cloneable,
        DryRunSupportedRequest<DescribeClientVpnEndpointsRequest> {

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> clientVpnEndpointIds;
    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the nextToken value.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     * </p>
     * </li>
     * </ul>
     */
    private com.amazonaws.internal.SdkInternalList<Filter> filters;

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint.
     */

    public java.util.List<String> getClientVpnEndpointIds() {
        if (clientVpnEndpointIds == null) {
            clientVpnEndpointIds = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return clientVpnEndpointIds;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     * 
     * @param clientVpnEndpointIds
     *        The ID of the Client VPN endpoint.
     */

    public void setClientVpnEndpointIds(java.util.Collection<String> clientVpnEndpointIds) {
        if (clientVpnEndpointIds == null) {
            this.clientVpnEndpointIds = null;
            return;
        }

        this.clientVpnEndpointIds = new com.amazonaws.internal.SdkInternalList<String>(clientVpnEndpointIds);
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setClientVpnEndpointIds(java.util.Collection)} or {@link #withClientVpnEndpointIds(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param clientVpnEndpointIds
     *        The ID of the Client VPN endpoint.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeClientVpnEndpointsRequest withClientVpnEndpointIds(String... clientVpnEndpointIds) {
        if (this.clientVpnEndpointIds == null) {
            setClientVpnEndpointIds(new com.amazonaws.internal.SdkInternalList<String>(clientVpnEndpointIds.length));
        }
        for (String ele : clientVpnEndpointIds) {
            this.clientVpnEndpointIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     * 
     * @param clientVpnEndpointIds
     *        The ID of the Client VPN endpoint.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeClientVpnEndpointsRequest withClientVpnEndpointIds(java.util.Collection<String> clientVpnEndpointIds) {
        setClientVpnEndpointIds(clientVpnEndpointIds);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the nextToken value.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return for the request in a single page. The remaining results can be
     *        seen by sending another request with the nextToken value.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the nextToken value.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the nextToken value.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the nextToken value.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return for the request in a single page. The remaining results can be
     *        seen by sending another request with the nextToken value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeClientVpnEndpointsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @param nextToken
     *        The token to retrieve the next page of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @param nextToken
     *        The token to retrieve the next page of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeClientVpnEndpointsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     * </p>
     * </li>
     * </ul>
     * 
     * @return One or more filters. Filter names and values are case-sensitive.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     *         </p>
     *         </li>
     */

    public java.util.List<Filter> getFilters() {
        if (filters == null) {
            filters = new com.amazonaws.internal.SdkInternalList<Filter>();
        }
        return filters;
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     * </p>
     * </li>
     * </ul>
     * 
     * @param filters
     *        One or more filters. Filter names and values are case-sensitive.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     *        </p>
     *        </li>
     */

    public void setFilters(java.util.Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }

        this.filters = new com.amazonaws.internal.SdkInternalList<Filter>(filters);
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param filters
     *        One or more filters. Filter names and values are case-sensitive.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeClientVpnEndpointsRequest withFilters(Filter... filters) {
        if (this.filters == null) {
            setFilters(new com.amazonaws.internal.SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     * </p>
     * </li>
     * </ul>
     * 
     * @param filters
     *        One or more filters. Filter names and values are case-sensitive.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>endpoint-id</code> - The ID of the Client VPN endpoint.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeClientVpnEndpointsRequest withFilters(java.util.Collection<Filter> filters) {
        setFilters(filters);
        return this;
    }

    /**
     * This method is intended for internal use only. Returns the marshaled request configured with additional
     * parameters to enable operation dry-run.
     */
    @Override
    public Request<DescribeClientVpnEndpointsRequest> getDryRunRequest() {
        Request<DescribeClientVpnEndpointsRequest> request = new DescribeClientVpnEndpointsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientVpnEndpointIds() != null)
            sb.append("ClientVpnEndpointIds: ").append(getClientVpnEndpointIds()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getFilters() != null)
            sb.append("Filters: ").append(getFilters());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeClientVpnEndpointsRequest == false)
            return false;
        DescribeClientVpnEndpointsRequest other = (DescribeClientVpnEndpointsRequest) obj;
        if (other.getClientVpnEndpointIds() == null ^ this.getClientVpnEndpointIds() == null)
            return false;
        if (other.getClientVpnEndpointIds() != null && other.getClientVpnEndpointIds().equals(this.getClientVpnEndpointIds()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getFilters() == null ^ this.getFilters() == null)
            return false;
        if (other.getFilters() != null && other.getFilters().equals(this.getFilters()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientVpnEndpointIds() == null) ? 0 : getClientVpnEndpointIds().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getFilters() == null) ? 0 : getFilters().hashCode());
        return hashCode;
    }

    @Override
    public DescribeClientVpnEndpointsRequest clone() {
        return (DescribeClientVpnEndpointsRequest) super.clone();
    }
}
