/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyInstancePlacementRequestMarshaller
implements Marshaller<Request<ModifyInstancePlacementRequest>, ModifyInstancePlacementRequest> {
    public Request<ModifyInstancePlacementRequest> marshall(ModifyInstancePlacementRequest modifyInstancePlacementRequest) {
        if (modifyInstancePlacementRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyInstancePlacementRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyInstancePlacement");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstancePlacementRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)modifyInstancePlacementRequest.getInstanceId()));
        }
        if (modifyInstancePlacementRequest.getTenancy() != null) {
            request.addParameter("Tenancy", StringUtils.fromString((String)modifyInstancePlacementRequest.getTenancy()));
        }
        if (modifyInstancePlacementRequest.getAffinity() != null) {
            request.addParameter("Affinity", StringUtils.fromString((String)modifyInstancePlacementRequest.getAffinity()));
        }
        if (modifyInstancePlacementRequest.getHostId() != null) {
            request.addParameter("HostId", StringUtils.fromString((String)modifyInstancePlacementRequest.getHostId()));
        }
        return request;
    }
}

