/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateNatGatewayRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateNatGatewayRequestMarshaller
implements Marshaller<Request<CreateNatGatewayRequest>, CreateNatGatewayRequest> {
    public Request<CreateNatGatewayRequest> marshall(CreateNatGatewayRequest createNatGatewayRequest) {
        if (createNatGatewayRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNatGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNatGateway");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNatGatewayRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNatGatewayRequest.getSubnetId()));
        }
        if (createNatGatewayRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)createNatGatewayRequest.getAllocationId()));
        }
        if (createNatGatewayRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createNatGatewayRequest.getClientToken()));
        }
        return request;
    }
}

