/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        if (modifyVpcEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2015-04-15");
        if (modifyVpcEndpointRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString((String)modifyVpcEndpointRequest.getVpcEndpointId()));
        }
        if (modifyVpcEndpointRequest.isResetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean((Boolean)modifyVpcEndpointRequest.isResetPolicy()));
        }
        if (modifyVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)modifyVpcEndpointRequest.getPolicyDocument()));
        }
        List<String> addRouteTableIdsList = modifyVpcEndpointRequest.getAddRouteTableIds();
        int addRouteTableIdsListIndex = 1;
        for (String addRouteTableIdsListValue : addRouteTableIdsList) {
            if (addRouteTableIdsListValue != null) {
                request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString((String)addRouteTableIdsListValue));
            }
            ++addRouteTableIdsListIndex;
        }
        List<String> removeRouteTableIdsList = modifyVpcEndpointRequest.getRemoveRouteTableIds();
        int removeRouteTableIdsListIndex = 1;
        for (String removeRouteTableIdsListValue : removeRouteTableIdsList) {
            if (removeRouteTableIdsListValue != null) {
                request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString((String)removeRouteTableIdsListValue));
            }
            ++removeRouteTableIdsListIndex;
        }
        return request;
    }
}

