/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeCustomerGatewaysRequestMarshaller
implements Marshaller<Request<DescribeCustomerGatewaysRequest>, DescribeCustomerGatewaysRequest> {
    public Request<DescribeCustomerGatewaysRequest> marshall(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        SdkInternalList filtersList;
        if (describeCustomerGatewaysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCustomerGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeCustomerGateways");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList customerGatewayIdsList = (SdkInternalList)describeCustomerGatewaysRequest.getCustomerGatewayIds();
        if (!customerGatewayIdsList.isEmpty() || !customerGatewayIdsList.isAutoConstruct()) {
            int customerGatewayIdsListIndex = 1;
            for (String customerGatewayIdsListValue : customerGatewayIdsList) {
                if (customerGatewayIdsListValue != null) {
                    request.addParameter("CustomerGatewayId." + customerGatewayIdsListIndex, StringUtils.fromString((String)customerGatewayIdsListValue));
                }
                ++customerGatewayIdsListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeCustomerGatewaysRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

