/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RevokeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupEgressRequest>, RevokeSecurityGroupEgressRequest> {
    public Request<RevokeSecurityGroupEgressRequest> marshall(RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest) {
        SdkInternalList ipPermissionsList;
        if (revokeSecurityGroupEgressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeSecurityGroupEgressRequest, "AmazonEC2");
        request.addParameter("Action", "RevokeSecurityGroupEgress");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupEgressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getGroupId()));
        }
        if (revokeSecurityGroupEgressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getSourceSecurityGroupName()));
        }
        if (revokeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (revokeSecurityGroupEgressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getIpProtocol()));
        }
        if (revokeSecurityGroupEgressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.getFromPort()));
        }
        if (revokeSecurityGroupEgressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.getToPort()));
        }
        if (revokeSecurityGroupEgressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.getCidrIp()));
        }
        if (!(ipPermissionsList = (SdkInternalList)revokeSecurityGroupEgressRequest.getIpPermissions()).isEmpty() || !ipPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission ipPermissionsListValue : ipPermissionsList) {
                SdkInternalList prefixListIdsList;
                SdkInternalList ipRangesList;
                SdkInternalList userIdGroupPairsList;
                if (ipPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)ipPermissionsListValue.getIpProtocol()));
                }
                if (ipPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)ipPermissionsListValue.getFromPort()));
                }
                if (ipPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)ipPermissionsListValue.getToPort()));
                }
                if (!(userIdGroupPairsList = (SdkInternalList)ipPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !userIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (UserIdGroupPair userIdGroupPairsListValue : userIdGroupPairsList) {
                        if (userIdGroupPairsListValue.getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)userIdGroupPairsListValue.getUserId()));
                        }
                        if (userIdGroupPairsListValue.getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)userIdGroupPairsListValue.getGroupName()));
                        }
                        if (userIdGroupPairsListValue.getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)userIdGroupPairsListValue.getGroupId()));
                        }
                        if (userIdGroupPairsListValue.getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)userIdGroupPairsListValue.getVpcId()));
                        }
                        if (userIdGroupPairsListValue.getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)userIdGroupPairsListValue.getVpcPeeringConnectionId()));
                        }
                        if (userIdGroupPairsListValue.getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)userIdGroupPairsListValue.getPeeringStatus()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipRangesList = (SdkInternalList)ipPermissionsListValue.getIpRanges()).isEmpty() || !ipRangesList.isAutoConstruct()) {
                    int ipRangesListIndex = 1;
                    for (String ipRangesListValue : ipRangesList) {
                        if (ipRangesListValue != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipRangesListIndex + ".CidrIp", StringUtils.fromString((String)ipRangesListValue));
                        }
                        ++ipRangesListIndex;
                    }
                }
                if (!(prefixListIdsList = (SdkInternalList)ipPermissionsListValue.getPrefixListIds()).isEmpty() || !prefixListIdsList.isAutoConstruct()) {
                    int prefixListIdsListIndex = 1;
                    for (PrefixListId prefixListIdsListValue : prefixListIdsList) {
                        if (prefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)prefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        return request;
    }
}

