/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeCustomerGatewaysRequestMarshaller
implements Marshaller<Request<DescribeCustomerGatewaysRequest>, DescribeCustomerGatewaysRequest> {
    public Request<DescribeCustomerGatewaysRequest> marshall(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        if (describeCustomerGatewaysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCustomerGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeCustomerGateways");
        request.addParameter("Version", "2015-10-01");
        List<String> customerGatewayIdsList = describeCustomerGatewaysRequest.getCustomerGatewayIds();
        int customerGatewayIdsListIndex = 1;
        for (String customerGatewayIdsListValue : customerGatewayIdsList) {
            if (customerGatewayIdsListValue != null) {
                request.addParameter("CustomerGatewayId." + customerGatewayIdsListIndex, StringUtils.fromString((String)customerGatewayIdsListValue));
            }
            ++customerGatewayIdsListIndex;
        }
        List<Filter> filtersList = describeCustomerGatewaysRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

