/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.AllocateHostsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AllocateHostsRequestMarshaller
implements Marshaller<Request<AllocateHostsRequest>, AllocateHostsRequest> {
    public Request<AllocateHostsRequest> marshall(AllocateHostsRequest allocateHostsRequest) {
        if (allocateHostsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)allocateHostsRequest, "AmazonEC2");
        request.addParameter("Action", "AllocateHosts");
        request.addParameter("Version", "2015-10-01");
        if (allocateHostsRequest.getAutoPlacement() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString((String)allocateHostsRequest.getAutoPlacement()));
        }
        if (allocateHostsRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)allocateHostsRequest.getClientToken()));
        }
        if (allocateHostsRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)allocateHostsRequest.getInstanceType()));
        }
        if (allocateHostsRequest.getQuantity() != null) {
            request.addParameter("Quantity", StringUtils.fromInteger((Integer)allocateHostsRequest.getQuantity()));
        }
        if (allocateHostsRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)allocateHostsRequest.getAvailabilityZone()));
        }
        return request;
    }
}

